/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.libraries.minedown.minedown.MineDown;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private static final Map<String, String> messages = new HashMap<String, String>();
    private static final HuskBungeeRTP plugin = HuskBungeeRTP.getInstance();

    private static void createFile(File f) {
        try {
            if (!f.createNewFile()) {
                Bukkit.getLogger().severe("Failed to create messages.yml file!");
            }
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("An error occurred while creating the messages.yml file!");
            e.printStackTrace();
        }
    }

    private static void saveFile(FileConfiguration config, File f) {
        try {
            config.save(f);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("An error occurred while saving the messages.yml file!");
        }
    }

    public static void loadMessages() {
        File messagesFile = new File(plugin.getDataFolder() + File.separator + "messages.yml");
        if (!messagesFile.exists()) {
            MessageManager.createFile(messagesFile);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)messagesFile);
        config.options().header(" ------------------------------ \n|    HuskBungeeRTP Messages    |\n|    Developed by William278   |\n ------------------------------ \nChange the appearance/text of messages in the plugin using this config. \nThis config makes use of MineDown formatting, with extensive support for custom colors & formats. \nFor formatting help, see the MineDown wiki: https://github.com/Phoenix616/MineDown");
        InputStream defaultMessageFile = plugin.getResource("messages.yml");
        if (defaultMessageFile != null) {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultMessageFile, StandardCharsets.UTF_8));
            config.setDefaults((Configuration)yamlConfiguration);
            config.options().copyHeader(true).copyDefaults(true);
        }
        MessageManager.saveFile((FileConfiguration)config, messagesFile);
        messages.clear();
        for (String message : config.getKeys(false)) {
            messages.put(message, StringEscapeUtils.unescapeJava((String)config.getString(message)));
        }
    }

    public static void sendMessage(CommandSender sender, String messageID, String ... placeholderReplacements) {
        String message = MessageManager.getRawMessage(messageID);
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        int replacementIndexer = 1;
        for (String replacement : placeholderReplacements) {
            String replacementString = "%" + replacementIndexer + "%";
            message = message.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        sender.spigot().sendMessage(new MineDown(message).replace(new String[0]).toComponent());
    }

    public static void sendMessage(CommandSender sender, String messageID) {
        String message = MessageManager.getRawMessage(messageID);
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        sender.spigot().sendMessage(new MineDown(message).replace(new String[0]).toComponent());
    }

    public static String getRawMessage(String messageID) {
        return messages.get(messageID);
    }
}

