/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.plan;

import com.djrapitops.plan.query.CommonQueries;
import com.djrapitops.plan.query.QueryService;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.william278.huskbungeertp.HuskBungeeRTP;

public record PlanQueryAccessor(QueryService queryService) {
    static final String GET_SERVER_NAME_SQL = "SELECT * FROM plan_servers WHERE `uuid`=?;";
    static final String GET_SESSION_TOTAL_WITHIN_DAY_LIMIT_SQL = "SELECT SUM(session_end-session_start) as playtime FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=?";

    public PlanQueryAccessor(QueryService queryService) {
        this.queryService = queryService;
        this.ensureDBSchemaMatch();
    }

    private void ensureDBSchemaMatch() {
        CommonQueries queries = this.queryService.getCommonQueries();
        if (!queries.doesDBHaveTable("plan_sessions") || !queries.doesDBHaveTableColumn("plan_sessions", "uuid")) {
            throw new IllegalStateException("Different table schema");
        }
    }

    public HashMap<String, Long> getPlayTimes() {
        Set UUIDList = this.queryService.getCommonQueries().fetchServerUUIDs();
        HashMap<String, Long> serverPlayTimes = new HashMap<String, Long>();
        for (UUID serverUUID : UUIDList) {
            String serverName = (String)this.queryService.query(GET_SERVER_NAME_SQL, preparedStatement -> {
                preparedStatement.setString(1, serverUUID.toString());
                try (ResultSet set = preparedStatement.executeQuery();){
                    String string = set.next() ? set.getString("name") : null;
                    return string;
                }
            });
            if (serverName.equalsIgnoreCase("proxy") || serverName.equalsIgnoreCase("bungee") || serverName.equalsIgnoreCase("waterfall") || serverName.equalsIgnoreCase("lavacord")) continue;
            long playtime = (Long)this.queryService.query(GET_SESSION_TOTAL_WITHIN_DAY_LIMIT_SQL, statement -> {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, System.currentTimeMillis() - TimeUnit.DAYS.toMillis(HuskBungeeRTP.getSettings().getPlanAveragePlayerCountDays()));
                statement.setLong(3, System.currentTimeMillis());
                try (ResultSet set = statement.executeQuery();){
                    Long l = set.next() ? set.getLong("playtime") : -1L;
                    return l;
                }
            });
            serverPlayTimes.put(serverName, playtime);
        }
        return serverPlayTimes;
    }
}

