/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import me.william278.huskbungeertp.EventListener;
import me.william278.huskbungeertp.MessageManager;
import me.william278.huskbungeertp.command.HuskBungeeRtpCommand;
import me.william278.huskbungeertp.command.RtpCommand;
import me.william278.huskbungeertp.config.Group;
import me.william278.huskbungeertp.config.Settings;
import me.william278.huskbungeertp.jedis.RedisMessage;
import me.william278.huskbungeertp.jedis.RedisMessenger;
import me.william278.huskbungeertp.libraries.bstats.bukkit.Metrics;
import me.william278.huskbungeertp.libraries.bstats.charts.SimplePie;
import me.william278.huskbungeertp.mysql.DataHandler;
import me.william278.huskbungeertp.plan.PlanDataManager;
import me.william278.huskbungeertp.randomtp.processor.AbstractRtp;
import me.william278.huskbungeertp.randomtp.processor.DefaultRtp;
import me.william278.huskbungeertp.randomtp.processor.JakesRtp;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HuskBungeeRTP
extends JavaPlugin {
    private static final int METRICS_PLUGIN_ID = 12830;
    private static HuskBungeeRTP instance;
    private static Settings settings;
    public static Logger rtpLogger;
    public static HashMap<String, Integer> serverPlayerCounts;
    private static AbstractRtp abstractRtp;

    public static HuskBungeeRTP getInstance() {
        return instance;
    }

    public static Settings getSettings() {
        return settings;
    }

    private void setSettings(Configuration config) {
        settings = new Settings(config);
    }

    public static void updateServerPlayerCounts() {
        for (String server : HuskBungeeRTP.getSettings().getAllServerIds()) {
            RedisMessenger.publish(new RedisMessage(server, RedisMessage.RedisMessageType.GET_PLAYER_COUNT, HuskBungeeRTP.getSettings().getServerId() + "#" + Instant.now().getEpochSecond()));
        }
    }

    public static HashSet<String> getServerIdsWithFewestPlayers(Collection<Group.Server> servers) {
        HashSet<String> lowestIdServers = new HashSet<String>();
        int lowestPlayerCount = Integer.MAX_VALUE;
        for (Group.Server server : servers) {
            if (serverPlayerCounts.containsKey(server.getName())) {
                String serverName = server.getName();
                int playerCount = serverPlayerCounts.get(serverName);
                if (playerCount < lowestPlayerCount) {
                    lowestPlayerCount = playerCount;
                    lowestIdServers.clear();
                    lowestIdServers.add(serverName);
                    continue;
                }
                if (playerCount != lowestPlayerCount) continue;
                lowestIdServers.add(serverName);
                continue;
            }
            HuskBungeeRTP.getInstance().getLogger().warning("A server in a RTP group failed to return play count data.");
        }
        return lowestIdServers;
    }

    public static AbstractRtp getAbstractRtp() {
        return abstractRtp;
    }

    private void setAbstractRtp() {
        abstractRtp = Bukkit.getPluginManager().getPlugin("JakesRTP") != null ? new JakesRtp() : new DefaultRtp();
        abstractRtp.initialize();
    }

    private void setupLogger() {
        rtpLogger = Logger.getLogger("RTPLogger");
        try {
            FileHandler loggerFile = new FileHandler(this.getDataFolder().getAbsolutePath() + File.separator + "RTPLogger.log");
            rtpLogger.addHandler(loggerFile);
            SimpleFormatter formatter = new SimpleFormatter();
            loggerFile.setFormatter(formatter);
            rtpLogger.info("Server " + HuskBungeeRTP.getSettings().getServerId() + " initialized.");
        }
        catch (SecurityException e) {
            this.getLogger().log(Level.WARNING, "A logger SecurityException has occurred", e);
        }
        catch (IOException i) {
            this.getLogger().log(Level.WARNING, "A logger IOException has occurred", i);
        }
    }

    public void onLoad() {
        instance = this;
    }

    public static void reloadConfigFile() {
        HuskBungeeRTP instance = HuskBungeeRTP.getInstance();
        instance.reloadConfig();
        instance.saveDefaultConfig();
        instance.setSettings((Configuration)instance.getConfig());
        MessageManager.loadMessages();
    }

    public void onEnable() {
        HuskBungeeRTP.reloadConfigFile();
        DataHandler.loadDatabase(HuskBungeeRTP.getInstance());
        this.setAbstractRtp();
        Objects.requireNonNull(this.getCommand("rtp")).setExecutor((CommandExecutor)new RtpCommand());
        Objects.requireNonNull(this.getCommand("rtp")).setTabCompleter((TabCompleter)new RtpCommand.RtpTabCompleter());
        Objects.requireNonNull(this.getCommand("huskbungeertp")).setExecutor((CommandExecutor)new HuskBungeeRtpCommand());
        Objects.requireNonNull(this.getCommand("huskbungeertp")).setTabCompleter((TabCompleter)new HuskBungeeRtpCommand.HuskBungeeRtpTabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)this);
        switch (HuskBungeeRTP.getSettings().getLoadBalancingMethod()) {
            case PLAN: {
                PlanDataManager.updatePlanPlayTimes();
                break;
            }
            case PLAYER_COUNTS: {
                HuskBungeeRTP.updateServerPlayerCounts();
            }
        }
        RedisMessenger.subscribe();
        try {
            Metrics metrics = new Metrics(this, 12830);
            metrics.addCustomChart(new SimplePie("plan_integration", () -> Boolean.toString(PlanDataManager.usePlanIntegration())));
            metrics.addCustomChart(new SimplePie("jakes_rtp", () -> Boolean.toString(abstractRtp instanceof JakesRtp)));
        }
        catch (Exception e) {
            this.getLogger().warning("An exception occurred initialising metrics; skipping.");
        }
        if (HuskBungeeRTP.getSettings().doDebugLogging()) {
            this.setupLogger();
        }
        this.getLogger().info("Successfully enabled HuskBungeeRTP v" + this.getDescription().getVersion());
    }

    public void onDisable() {
        DataHandler.closeDatabase();
        this.getLogger().info("Disabled HuskBungeeRTP v" + this.getDescription().getVersion());
    }

    static {
        serverPlayerCounts = new HashMap();
    }
}

