/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.config;

import java.util.HashSet;
import java.util.Objects;
import me.william278.huskbungeertp.config.Group;
import org.bukkit.configuration.Configuration;

public class Settings {
    private final String databaseHost;
    private final int databasePort;
    private final String databaseUsername;
    private final String databasePassword;
    private final String databaseName;
    private final String databasePlayerTableName;
    private final String databaseParams;
    private final int hikariMaximumPoolSize;
    private final int hikariMinimumIdle;
    private final long hikariMaximumLifetime;
    private final long hikariKeepAliveTime;
    private final long hikariConnectionTimeOut;
    private final String redisHost;
    private final int redisPort;
    private final String redisPassword;
    private final String serverId;
    private final boolean useLastRtpLocationOnCoolDown;
    private final String defaultRtpDestinationGroup;
    private final int maxRtpAttempts;
    private final boolean debugLogging;
    private final int rtpTimeOutSeconds;
    private final LoadBalancingMethod loadBalancingMethod;
    private final int planUpdateFrequencyMinutes;
    private final int planAveragePlayerCountDays;
    private final HashSet<Group> groups;

    public Settings(Configuration config) {
        this.databaseHost = config.getString("mysql_credentials.host", "localhost");
        this.databasePort = config.getInt("mysql_credentials.port", 3306);
        this.databaseUsername = config.getString("mysql_credentials.username", "root");
        this.databasePassword = config.getString("mysql_credentials.password", "pa55w0rd");
        this.databaseName = config.getString("mysql_credentials.database", "huskrtp");
        this.databasePlayerTableName = config.getString("mysql_credentials.player_table_name", "huskrtp_players");
        this.databaseParams = config.getString("mysql_credentials.params", "?autoReconnect=true&useSSL=false");
        this.hikariMaximumPoolSize = config.getInt("mysql_credentials.connection_pool_options.maximum_pool_size", 10);
        this.hikariMinimumIdle = config.getInt("mysql_credentials.connection_pool_options.minimum_idle", 10);
        this.hikariMaximumLifetime = config.getLong("mysql_credentials.connection_pool_options.maximum_lifetime", 1800000L);
        this.hikariKeepAliveTime = config.getLong("mysql_credentials.connection_pool_options.keepalive_time", 0L);
        this.hikariConnectionTimeOut = config.getLong("mysql_credentials.connection_pool_options.connection_timeout", 5000L);
        this.redisHost = config.getString("redis_credentials.host", "localhost");
        this.redisPort = config.getInt("redis_credentials.port", 3306);
        this.redisPassword = config.getString("redis_credentials.password", "");
        this.loadBalancingMethod = LoadBalancingMethod.valueOf(config.getString("load_balancing.method", "random").toUpperCase());
        this.planUpdateFrequencyMinutes = config.getInt("load_balancing.plan.update_frequency_mins", 1);
        this.planAveragePlayerCountDays = config.getInt("load_balancing.plan.average_player_count_days", 7);
        this.serverId = config.getString("this_server_id", "server1");
        this.useLastRtpLocationOnCoolDown = config.getBoolean("last_rtp_on_cooldown", true);
        this.defaultRtpDestinationGroup = config.getString("default_rtp_group", "group1");
        this.maxRtpAttempts = config.getInt("max_rtp_attempts", 10);
        this.debugLogging = config.getBoolean("debug_logging", false);
        this.rtpTimeOutSeconds = config.getInt("rtp_time_out_seconds", 20);
        this.groups = this.getGroups(config);
    }

    private HashSet<Group> getGroups(Configuration config) {
        HashSet<Group> groups = new HashSet<Group>();
        for (String groupId : Objects.requireNonNull(config.getConfigurationSection("groups")).getKeys(false)) {
            String tableName = config.getString("groups." + groupId + ".table_name");
            int coolDownMinutes = config.getInt("groups." + groupId + ".cooldown_minutes");
            HashSet<Group.Server> servers = this.getGroupServers(config, groupId);
            groups.add(new Group(groupId, tableName, coolDownMinutes, servers));
        }
        return groups;
    }

    private HashSet<Group.Server> getGroupServers(Configuration config, String groupId) {
        HashSet<Group.Server> servers = new HashSet<Group.Server>();
        for (String groupServerId : Objects.requireNonNull(config.getConfigurationSection("groups." + groupId + ".servers_worlds")).getKeys(false)) {
            HashSet<String> serverWorlds = new HashSet<String>(config.getStringList("groups." + groupId + ".servers_worlds." + groupServerId));
            servers.add(new Group.Server(groupServerId, serverWorlds));
        }
        return servers;
    }

    public String getDatabaseHost() {
        return this.databaseHost;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabasePlayerTableName() {
        return this.databasePlayerTableName;
    }

    public String getDatabaseParams() {
        return this.databaseParams;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public int getPlanUpdateFrequencyMinutes() {
        return this.planUpdateFrequencyMinutes;
    }

    public LoadBalancingMethod getLoadBalancingMethod() {
        return this.loadBalancingMethod;
    }

    public Group getDefaultRtpDestinationGroup() {
        return this.getGroupById(this.defaultRtpDestinationGroup);
    }

    public long getPlanAveragePlayerCountDays() {
        return this.planAveragePlayerCountDays;
    }

    public boolean isUseLastRtpLocationOnCoolDown() {
        return this.useLastRtpLocationOnCoolDown;
    }

    public boolean doDebugLogging() {
        return this.debugLogging;
    }

    public int getRtpTimeOutSeconds() {
        return this.rtpTimeOutSeconds;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getHikariMaximumPoolSize() {
        return this.hikariMaximumPoolSize;
    }

    public int getHikariMinimumIdle() {
        return this.hikariMinimumIdle;
    }

    public long getHikariMaximumLifetime() {
        return this.hikariMaximumLifetime;
    }

    public long getHikariKeepAliveTime() {
        return this.hikariKeepAliveTime;
    }

    public long getHikariConnectionTimeOut() {
        return this.hikariConnectionTimeOut;
    }

    public HashSet<String> getAllServerIds() {
        HashSet<String> servers = new HashSet<String>();
        for (Group group : this.getGroups()) {
            for (Group.Server server : group.getServers()) {
                servers.add(server.getName());
            }
        }
        return servers;
    }

    public HashSet<Group> getGroups() {
        return this.groups;
    }

    public HashSet<String> getGroupIds() {
        HashSet<String> groupNames = new HashSet<String>();
        for (Group group : this.groups) {
            groupNames.add(group.getGroupId());
        }
        return groupNames;
    }

    public Group getThisServerGroup() {
        for (Group group : this.groups) {
            for (Group.Server server : group.getServers()) {
                if (!this.serverId.equals(server.getName())) continue;
                return group;
            }
        }
        return null;
    }

    public Group getGroupById(String groupId) {
        for (Group group : this.groups) {
            if (!group.getGroupId().equals(groupId)) continue;
            return group;
        }
        return null;
    }

    public int getMaxRtpAttempts() {
        return this.maxRtpAttempts;
    }

    public static enum LoadBalancingMethod {
        PLAN,
        PLAYER_COUNTS,
        RANDOM;

    }
}

