/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.jedis;

import java.util.UUID;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.HuskHomesExecutor;
import me.william278.huskbungeertp.MessageManager;
import me.william278.huskbungeertp.jedis.RedisMessage;
import me.william278.huskbungeertp.mysql.DataHandler;
import me.william278.huskbungeertp.randomtp.RtpHandler;
import me.william278.huskbungeertp.randomtp.processor.AbstractRtp;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class RedisMessenger {
    private static final String REDIS_CHANNEL = "HuskBungeeRtp";

    public static void subscribe() {
        Jedis jedis = new Jedis(HuskBungeeRTP.getSettings().getRedisHost(), HuskBungeeRTP.getSettings().getRedisPort());
        String jedisPassword = HuskBungeeRTP.getSettings().getRedisPassword();
        if (!jedisPassword.equals("")) {
            jedis.auth(jedisPassword);
        }
        jedis.connect();
        new Thread(() -> jedis.subscribe(new JedisPubSub(){

            public void onMessage(String channel, String message) {
                if (!channel.equals(RedisMessenger.REDIS_CHANNEL)) {
                    return;
                }
                String[] splitMessage = message.split("\u00a3");
                RedisMessage receivedMessage = new RedisMessage(splitMessage[0], RedisMessage.RedisMessageType.valueOf(splitMessage[1]), splitMessage[2]);
                if (!receivedMessage.getTargetServer().equals(HuskBungeeRTP.getSettings().getServerId())) {
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)HuskBungeeRTP.getInstance(), () -> RedisMessenger.handleReceivedMessage(receivedMessage));
            }
        }, new String[]{REDIS_CHANNEL}), "Redis Subscriber").start();
    }

    public static void publish(RedisMessage message) {
        try (Jedis publisher = new Jedis(HuskBungeeRTP.getSettings().getRedisHost(), HuskBungeeRTP.getSettings().getRedisPort());){
            String jedisPassword = HuskBungeeRTP.getSettings().getRedisPassword();
            if (!jedisPassword.equals("")) {
                publisher.auth(jedisPassword);
            }
            publisher.connect();
            publisher.publish(REDIS_CHANNEL, message.toString());
        }
    }

    public static void handleReceivedMessage(RedisMessage message) {
        String[] messageData = message.getMessageData().split("#");
        switch (message.getMessageType()) {
            case REPLY_RANDOM_FAILED: {
                UUID originPlayerUUID = UUID.fromString(messageData[0]);
                int attemptsTaken = Integer.parseInt(messageData[1]);
                Player player = Bukkit.getPlayer((UUID)originPlayerUUID);
                if (player != null) {
                    MessageManager.sendMessage((CommandSender)player, "error_rtp_failed", Integer.toString(attemptsTaken));
                }
                RtpHandler.removeRtpUser(originPlayerUUID);
                break;
            }
            case REQUEST_RANDOM_LOCATION: {
                UUID sourcePlayerUUID = UUID.fromString(messageData[0]);
                String sourceServer = messageData[1];
                String targetWorld = messageData[2];
                String targetBiomeString = messageData[3];
                String targetGroupId = messageData[4];
                World world = Bukkit.getWorld((String)targetWorld);
                if (world == null) break;
                AbstractRtp.RandomResult result = HuskBungeeRTP.getAbstractRtp().getRandomLocation(world, targetBiomeString);
                if (!result.successful()) {
                    RedisMessenger.publish(new RedisMessage(sourceServer, RedisMessage.RedisMessageType.REPLY_RANDOM_FAILED, sourcePlayerUUID + "#" + result.attemptsTaken()));
                    return;
                }
                Location randomLocation = result.location();
                world.getChunkAt(randomLocation);
                RedisMessenger.publish(new RedisMessage(sourceServer, RedisMessage.RedisMessageType.REPLY_RANDOM_LOCATION, sourcePlayerUUID + "#" + HuskBungeeRTP.getSettings().getServerId() + "#" + world.getName() + "#" + randomLocation.getX() + "#" + randomLocation.getY() + "#" + randomLocation.getZ() + "#" + targetGroupId));
                break;
            }
            case REPLY_RANDOM_LOCATION: {
                UUID originPlayerUUID = UUID.fromString(messageData[0]);
                String sourceServer = messageData[1];
                String locationWorld = messageData[2];
                double locationX = Double.parseDouble(messageData[3]);
                double locationY = Double.parseDouble(messageData[4]);
                double locationZ = Double.parseDouble(messageData[5]);
                String destinationGroupId = messageData[6];
                Player player = Bukkit.getPlayer((UUID)originPlayerUUID);
                if (player != null) {
                    HuskHomesExecutor.teleportPlayer(player, new TeleportationPoint(locationWorld, locationX, locationY, locationZ, 0.0f, 0.0f, sourceServer));
                    if (!player.hasPermission("huskrtp.bypass_cooldown")) {
                        DataHandler.setPlayerOnCoolDown(originPlayerUUID, HuskBungeeRTP.getSettings().getGroupById(destinationGroupId), new TeleportationPoint(locationWorld, locationX, locationY, locationZ, 0.0f, 0.0f, sourceServer));
                    }
                }
                RtpHandler.removeRtpUser(originPlayerUUID);
                break;
            }
            case GET_PLAYER_COUNT: {
                String sourceServer = messageData[0];
                RedisMessenger.publish(new RedisMessage(sourceServer, RedisMessage.RedisMessageType.RETURN_PLAYER_COUNT, HuskBungeeRTP.getSettings().getServerId() + "#" + Bukkit.getOnlinePlayers().size()));
                break;
            }
            case RETURN_PLAYER_COUNT: {
                String sourceServer = messageData[0];
                int sourcePlayerCount = Integer.parseInt(messageData[1]);
                HuskBungeeRTP.serverPlayerCounts.put(sourceServer, sourcePlayerCount);
            }
        }
    }
}

