/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Level;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.config.Group;
import me.william278.huskbungeertp.libraries.hikaricp.hikari.HikariDataSource;
import me.william278.huskbungeertp.mysql.Database;

public class MySQL
extends Database {
    public static final String PLAYER_TABLE_CREATION_STATEMENT = "CREATE TABLE IF NOT EXISTS " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " (`id` integer AUTO_INCREMENT PRIMARY KEY,`user_uuid` char(36) NOT NULL UNIQUE);";
    public static final String GROUP_TABLE_CREATION_STATEMENT = "CREATE TABLE IF NOT EXISTS {0} (`player_id` integer AUTO_INCREMENT PRIMARY KEY,`last_rtp` timestamp NOT NULL DEFAULT (CURRENT_TIMESTAMP),`dest_world` tinytext NOT NULL,`dest_x` double NOT NULL,`dest_y` double NOT NULL,`dest_z` double NOT NULL,`dest_server` tinytext NOT NULL);";
    final String host = HuskBungeeRTP.getSettings().getDatabaseHost();
    final int port = HuskBungeeRTP.getSettings().getDatabasePort();
    final String database = HuskBungeeRTP.getSettings().getDatabaseName();
    final String username = HuskBungeeRTP.getSettings().getDatabaseUsername();
    final String password = HuskBungeeRTP.getSettings().getDatabasePassword();
    final String params = HuskBungeeRTP.getSettings().getDatabaseParams();
    private HikariDataSource dataSource;

    public MySQL(HuskBungeeRTP instance) {
        super(instance);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void load() {
        String jdbcUrl = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + this.params;
        this.dataSource = new HikariDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        this.dataSource.setUsername(this.username);
        this.dataSource.setPassword(this.password);
        this.dataSource.setMaximumPoolSize(this.hikariMaximumPoolSize);
        this.dataSource.setMinimumIdle(this.hikariMinimumIdle);
        this.dataSource.setMaxLifetime(this.hikariMaximumLifetime);
        this.dataSource.setKeepaliveTime(this.hikariKeepAliveTime);
        this.dataSource.setConnectionTimeout(this.hikariConnectionTimeOut);
        this.dataSource.setPoolName("HuskBungeeRTPHikariPool");
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(PLAYER_TABLE_CREATION_STATEMENT);
            for (Group group : HuskBungeeRTP.getSettings().getGroups()) {
                statement.execute(MessageFormat.format(GROUP_TABLE_CREATION_STATEMENT, group.getGroupDatabaseTableName()));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occurred creating tables on the MySQL database: ", e);
        }
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }
}

