/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.plan;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.config.Group;
import me.william278.huskbungeertp.plan.PlanHook;
import me.william278.huskbungeertp.plan.PlanQueryAccessor;

public class PlanDataManager {
    private static long lastPlanFetch;
    private static boolean usePlan;
    private static HashMap<String, Long> planPlayTimes;

    public static HashMap<String, Long> getPlanPlayTimes() {
        return planPlayTimes;
    }

    public static boolean usePlanIntegration() {
        return usePlan;
    }

    public static HashSet<String> getServerIdsWithLowestPlayTime(Collection<Group.Server> servers) {
        HashSet<String> lowestIdServers = new HashSet<String>();
        long lowestPlayTime = Long.MAX_VALUE;
        for (Group.Server server : servers) {
            if (planPlayTimes.containsKey(server.getName())) {
                String serverName = server.getName();
                long playTime = planPlayTimes.get(serverName);
                if (playTime < lowestPlayTime) {
                    lowestPlayTime = playTime;
                    lowestIdServers.clear();
                    lowestIdServers.add(serverName);
                    continue;
                }
                if (playTime != lowestPlayTime) continue;
                lowestIdServers.add(serverName);
                continue;
            }
            HuskBungeeRTP.getInstance().getLogger().warning("A server in a RTP group failed to return Plan playtime data.");
        }
        return lowestIdServers;
    }

    public static void updatePlanPlayTimes() {
        try {
            Optional<PlanQueryAccessor> planHook = new PlanHook().hookIntoPlan();
            planHook.ifPresent(hook -> {
                usePlan = true;
                planPlayTimes = hook.getPlayTimes();
                HuskBungeeRTP.getInstance().getLogger().info("Fetched latest playtime data from Plan");
            });
            lastPlanFetch = Instant.now().getEpochSecond();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void fetchPlanIfNeeded() {
        if (lastPlanFetch + (long)HuskBungeeRTP.getSettings().getPlanUpdateFrequencyMinutes() * 60L <= Instant.now().getEpochSecond()) {
            PlanDataManager.updatePlanPlayTimes();
        }
    }

    static {
        usePlan = false;
        planPlayTimes = new HashMap();
    }
}

