/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.randomtp.processor;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.randomtp.processor.AbstractRtp;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;

public class DefaultRtp
extends AbstractRtp {
    private static final Set<Material> UNSAFE_BLOCKS = Collections.unmodifiableSet(EnumSet.of(Material.LAVA, new Material[]{Material.FIRE, Material.MAGMA_BLOCK, Material.CACTUS, Material.WATER, Material.OBSIDIAN, Material.JUNGLE_LEAVES, Material.SPRUCE_LEAVES, Material.OAK_LEAVES, Material.BIRCH_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES}));
    public static final int RADIUS = 5000;

    @Override
    public void initialize() {
    }

    @Override
    public AbstractRtp.RandomResult getRandomLocation(World world, String targetBiomeString) {
        int attempts;
        int maxAttempts = HuskBungeeRTP.getSettings().getMaxRtpAttempts();
        for (attempts = 0; attempts < maxAttempts; ++attempts) {
            Location randomLocation = this.randomLocation(world);
            boolean isLocationValid = this.isLocationSafe(randomLocation);
            if (!targetBiomeString.equalsIgnoreCase("ALL")) {
                Biome targetBiome = Biome.valueOf((String)targetBiomeString);
                if (world.getBiome(randomLocation.getBlockX(), randomLocation.getBlockY(), randomLocation.getBlockZ()) != targetBiome) {
                    isLocationValid = false;
                }
            }
            if (!isLocationValid) continue;
            return new AbstractRtp.RandomResult(randomLocation, true, attempts);
        }
        return new AbstractRtp.RandomResult(null, false, attempts);
    }

    private Location randomLocation(World world) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int y = 64;
        double blockCenterX = 0.5;
        double blockCenterZ = 0.5;
        int rtpRange = Math.min(5000, (int)world.getWorldBorder().getSize() - 1);
        int x = ((Random)random).nextInt(rtpRange);
        int z = ((Random)random).nextInt(rtpRange);
        if (((Random)random).nextBoolean()) {
            x *= -1;
            blockCenterX *= -1.0;
        }
        if (((Random)random).nextBoolean()) {
            z *= -1;
            blockCenterZ *= -1.0;
        }
        Location randomLocation = new Location(world, (double)x + blockCenterX, (double)y, (double)z + blockCenterZ);
        y = world.getHighestBlockYAt(randomLocation) + 1;
        randomLocation.setY((double)y);
        return randomLocation;
    }

    private boolean isLocationSafe(Location location) {
        int x = location.getBlockX();
        int y = location.getBlockY() - 1;
        int z = location.getBlockZ();
        World world = location.getWorld();
        if (world != null) {
            if (!world.getWorldBorder().isInside(location)) {
                return false;
            }
            Block block = world.getBlockAt(x, y, z);
            Block below = world.getBlockAt(x, y - 1, z);
            Block above = world.getBlockAt(x, y + 1, z);
            if (!UNSAFE_BLOCKS.contains(block.getType()) && block.getType().isSolid() && !UNSAFE_BLOCKS.contains(above.getType())) {
                return !UNSAFE_BLOCKS.contains(below.getType());
            }
        }
        return false;
    }
}

