/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.randomtp.processor;

import biz.donvi.jakesRTP.JakesRtpPlugin;
import biz.donvi.jakesRTP.RandomTeleporter;
import java.util.logging.Level;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.config.Group;
import me.william278.huskbungeertp.randomtp.processor.AbstractRtp;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.plugin.Plugin;

public class JakesRtp
extends AbstractRtp {
    private RandomTeleporter randomTeleporter;

    @Override
    public void initialize() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("JakesRTP");
        if (!(plugin instanceof JakesRtpPlugin)) {
            return;
        }
        this.randomTeleporter = ((JakesRtpPlugin)plugin).getRandomTeleporter();
        try {
            for (Group.Server server : HuskBungeeRTP.getSettings().getThisServerGroup().getServers()) {
                if (!server.getName().equals(HuskBungeeRTP.getSettings().getServerId())) continue;
                for (String worldName : server.getWorlds()) {
                    World world = Bukkit.getWorld((String)worldName);
                    if (world == null) continue;
                    this.randomTeleporter.fillQueue(this.randomTeleporter.getRtpSettingsByWorld(world));
                }
                break;
            }
        }
        catch (NullPointerException e) {
            HuskBungeeRTP.getInstance().getLogger().info("Skipped caching JakesRTP random locations as this server is not a group target.");
        }
        catch (Exception e) {
            HuskBungeeRTP.getInstance().getLogger().log(Level.WARNING, "An exception occurred caching JakesRTP random locations!", e);
        }
    }

    @Override
    public AbstractRtp.RandomResult getRandomLocation(World world, String targetBiomeString) {
        int maxAttempts = HuskBungeeRTP.getSettings().getMaxRtpAttempts();
        try {
            int attempts;
            if (targetBiomeString.equalsIgnoreCase("ALL")) {
                Location location = this.randomTeleporter.getRtpLocation(this.randomTeleporter.getRtpSettingsByWorld(world), world.getSpawnLocation(), true);
                return new AbstractRtp.RandomResult(location, true, 1);
            }
            Biome targetBiome = Biome.valueOf((String)targetBiomeString);
            for (attempts = 0; attempts < maxAttempts; ++attempts) {
                Location location = this.randomTeleporter.getRtpLocation(this.randomTeleporter.getRtpSettingsByWorld(world), world.getSpawnLocation(), true);
                if (location.getBlock().getBiome() != targetBiome) continue;
                return new AbstractRtp.RandomResult(location, true, attempts);
            }
            return new AbstractRtp.RandomResult(null, false, attempts);
        }
        catch (Exception e) {
            HuskBungeeRTP.getInstance().getLogger().log(Level.SEVERE, "An exception occurred fetching a random location!", e);
            return new AbstractRtp.RandomResult(null, false, 0);
        }
    }
}

