/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.libraries.jedis;

import java.io.Serializable;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAndPort
implements Serializable {
    private static final long serialVersionUID = -519876229978427751L;
    protected static Logger log = LoggerFactory.getLogger(HostAndPort.class.getName());
    public static volatile String localhost;
    private String host;
    private int port;

    public HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HostAndPort)) {
            return false;
        }
        HostAndPort hp = (HostAndPort)obj;
        String thisHost = HostAndPort.convertHost(this.host);
        String hpHost = HostAndPort.convertHost(hp.host);
        return this.port == hp.port && thisHost.equals(hpHost);
    }

    public int hashCode() {
        return 31 * HostAndPort.convertHost(this.host).hashCode() + this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public static HostAndPort from(String string) {
        int lastColon = string.lastIndexOf(":");
        String host = string.substring(0, lastColon);
        int port = Integer.parseInt(string.substring(lastColon + 1));
        return new HostAndPort(host, port);
    }

    public static String[] extractParts(String from) {
        int idx = from.lastIndexOf(58);
        String host = idx != -1 ? from.substring(0, idx) : from;
        String port = idx != -1 ? from.substring(idx + 1) : "";
        return new String[]{host, port};
    }

    public static HostAndPort parseString(String from) {
        try {
            String[] parts = HostAndPort.extractParts(from);
            String host = parts[0];
            int port = Integer.parseInt(parts[1]);
            return new HostAndPort(HostAndPort.convertHost(host), port);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String convertHost(String host) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            if (inetAddress.isLoopbackAddress() || host.equals("0.0.0.0") || host.startsWith("169.254")) {
                return HostAndPort.getLocalhost();
            }
        }
        catch (Exception e) {
            log.warn("{}.convertHost '{}' is not a valid IP address. ", HostAndPort.class.getName(), host, e);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocalhost(String localhost) {
        Class<HostAndPort> clazz = HostAndPort.class;
        synchronized (HostAndPort.class) {
            HostAndPort.localhost = localhost;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLocalhost() {
        if (localhost != null) return localhost;
        Class<HostAndPort> clazz = HostAndPort.class;
        synchronized (HostAndPort.class) {
            if (localhost != null) return localhost;
            localhost = HostAndPort.getLocalHostQuietly();
            // ** MonitorExit[var0] (shouldn't be in output)
            return localhost;
        }
    }

    public static String getLocalHostQuietly() {
        String localAddress;
        try {
            localAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception ex) {
            log.error("{}.getLocalHostQuietly : cant resolve localhost address", (Object)HostAndPort.class.getName(), (Object)ex);
            localAddress = "localhost";
        }
        return localAddress;
    }
}

