/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.libraries.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import me.william278.huskbungeertp.libraries.jedis.Client;
import me.william278.huskbungeertp.libraries.jedis.DefaultJedisClientConfig;
import me.william278.huskbungeertp.libraries.jedis.HostAndPort;
import me.william278.huskbungeertp.libraries.jedis.HostAndPortMapper;
import me.william278.huskbungeertp.libraries.jedis.Jedis;
import me.william278.huskbungeertp.libraries.jedis.JedisClientConfig;
import me.william278.huskbungeertp.libraries.jedis.JedisClusterHostAndPortMap;
import me.william278.huskbungeertp.libraries.jedis.JedisPool;
import me.william278.huskbungeertp.libraries.jedis.util.SafeEncoder;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class JedisClusterInfoCache {
    private final Map<String, JedisPool> nodes = new HashMap<String, JedisPool>();
    private final Map<Integer, JedisPool> slots = new HashMap<Integer, JedisPool>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock rediscoverLock = new ReentrantLock();
    private final GenericObjectPoolConfig<Jedis> poolConfig;
    private final JedisClientConfig clientConfig;
    private static final int MASTER_NODE_INDEX = 2;

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int timeout) {
        this(poolConfig, timeout, timeout, null, null);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName) {
        this(poolConfig, connectionTimeout, soTimeout, null, password, clientName);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String password, String clientName) {
        this(poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, null, password, clientName);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName) {
        this(poolConfig, connectionTimeout, soTimeout, user, password, clientName, false, null, null, null, (HostAndPortMapper)null);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName) {
        this(poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, clientName, false, null, null, null, (HostAndPortMapper)null);
    }

    @Deprecated
    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap hostAndPortMap) {
        this(poolConfig, connectionTimeout, soTimeout, null, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, hostAndPortMap);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, HostAndPortMapper hostAndPortMap) {
        this(poolConfig, connectionTimeout, soTimeout, null, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, hostAndPortMap);
    }

    @Deprecated
    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap hostAndPortMap) {
        this(poolConfig, connectionTimeout, soTimeout, 0, user, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, hostAndPortMap);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, HostAndPortMapper hostAndPortMap) {
        this(poolConfig, connectionTimeout, soTimeout, 0, user, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, hostAndPortMap);
    }

    @Deprecated
    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap hostAndPortMap) {
        this(poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, (HostAndPortMapper)hostAndPortMap);
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, HostAndPortMapper hostAndPortMap) {
        this(poolConfig, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).user(user).password(password).clientName(clientName).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).hostAndPortMapper(hostAndPortMap).build());
    }

    public JedisClusterInfoCache(GenericObjectPoolConfig<Jedis> poolConfig, JedisClientConfig clientConfig) {
        this.poolConfig = poolConfig;
        this.clientConfig = clientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverClusterNodesAndSlots(Jedis jedis) {
        this.w.lock();
        try {
            this.reset();
            List<Object> slots = jedis.clusterSlots();
            for (Object slotInfoObj : slots) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                int size = slotInfo.size();
                for (int i = 2; i < size; ++i) {
                    List hostInfos = (List)slotInfo.get(i);
                    if (hostInfos.isEmpty()) continue;
                    HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                    this.setupNodeIfNotExist(targetNode);
                    if (i != 2) continue;
                    this.assignSlotsToNode(slotNums, targetNode);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public void renewClusterSlots(Jedis jedis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.utils.finalhelp.FinalAnalyzer.identifyFinally(FinalAnalyzer.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.FinallyRewriter.identifyFinally(FinallyRewriter.java:40)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:548)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverClusterSlots(Jedis jedis) {
        List<Object> slots = jedis.clusterSlots();
        this.w.lock();
        try {
            this.slots.clear();
            for (Object slotInfoObj : slots) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                List hostInfos = (List)slotInfo.get(2);
                if (hostInfos.isEmpty()) continue;
                HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                this.assignSlotsToNode(slotNums, targetNode);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private HostAndPort generateHostAndPort(List<Object> hostInfos) {
        String host = SafeEncoder.encode((byte[])hostInfos.get(0));
        int port = ((Long)hostInfos.get(1)).intValue();
        return new HostAndPort(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JedisPool setupNodeIfNotExist(HostAndPort node) {
        this.w.lock();
        try {
            String nodeKey = JedisClusterInfoCache.getNodeKey(node);
            JedisPool existingPool = this.nodes.get(nodeKey);
            if (existingPool != null) {
                JedisPool jedisPool = existingPool;
                return jedisPool;
            }
            JedisPool nodePool = new JedisPool(this.poolConfig, node, this.clientConfig);
            this.nodes.put(nodeKey, nodePool);
            JedisPool jedisPool = nodePool;
            return jedisPool;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        this.w.lock();
        try {
            JedisPool targetPool = this.setupNodeIfNotExist(targetNode);
            this.slots.put(slot, targetPool);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotsToNode(List<Integer> targetSlots, HostAndPort targetNode) {
        this.w.lock();
        try {
            JedisPool targetPool = this.setupNodeIfNotExist(targetNode);
            for (Integer slot : targetSlots) {
                this.slots.put(slot, targetPool);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public JedisPool getNode(String nodeKey) {
        this.r.lock();
        try {
            JedisPool jedisPool = this.nodes.get(nodeKey);
            return jedisPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public JedisPool getSlotPool(int slot) {
        this.r.lock();
        try {
            JedisPool jedisPool = this.slots.get(slot);
            return jedisPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public Map<String, JedisPool> getNodes() {
        this.r.lock();
        try {
            HashMap<String, JedisPool> hashMap = new HashMap<String, JedisPool>(this.nodes);
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    public List<JedisPool> getShuffledNodesPool() {
        this.r.lock();
        try {
            ArrayList<JedisPool> pools = new ArrayList<JedisPool>(this.nodes.values());
            Collections.shuffle(pools);
            ArrayList<JedisPool> arrayList = pools;
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.w.lock();
        try {
            for (JedisPool pool : this.nodes.values()) {
                try {
                    if (pool == null) continue;
                    pool.destroy();
                }
                catch (Exception exception) {}
            }
            this.nodes.clear();
            this.slots.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    public static String getNodeKey(HostAndPort hnp) {
        return hnp.getHost() + ":" + hnp.getPort();
    }

    @Deprecated
    public static String getNodeKey(Client client) {
        return client.getHost() + ":" + client.getPort();
    }

    @Deprecated
    public static String getNodeKey(Jedis jedis) {
        return JedisClusterInfoCache.getNodeKey(jedis.getClient());
    }

    private List<Integer> getAssignedSlotArray(List<Object> slotInfo) {
        ArrayList<Integer> slotNums = new ArrayList<Integer>();
        for (int slot = ((Long)slotInfo.get(0)).intValue(); slot <= ((Long)slotInfo.get(1)).intValue(); ++slot) {
            slotNums.add(slot);
        }
        return slotNums;
    }
}

