/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.libraries.jedis;

import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import me.william278.huskbungeertp.libraries.jedis.HostAndPort;
import me.william278.huskbungeertp.libraries.jedis.Jedis;
import me.william278.huskbungeertp.libraries.jedis.JedisClientConfig;
import me.william278.huskbungeertp.libraries.jedis.JedisClusterConnectionHandler;
import me.william278.huskbungeertp.libraries.jedis.JedisClusterHostAndPortMap;
import me.william278.huskbungeertp.libraries.jedis.JedisPool;
import me.william278.huskbungeertp.libraries.jedis.exceptions.JedisException;
import me.william278.huskbungeertp.libraries.jedis.exceptions.JedisNoReachableClusterNodeException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class JedisSlotBasedConnectionHandler
extends JedisClusterConnectionHandler {
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int timeout) {
        this(nodes, poolConfig, timeout, timeout);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, null);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, password);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, password, clientName);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, user, password, clientName);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, clientName);
    }

    @Deprecated
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    @Deprecated
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, user, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    @Deprecated
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, JedisClientConfig clientConfig) {
        super(nodes, poolConfig, clientConfig);
    }

    @Override
    public Jedis getConnection() {
        List<JedisPool> pools = this.cache.getShuffledNodesPool();
        JedisException suppressed = null;
        for (JedisPool pool : pools) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                if (jedis.ping().equalsIgnoreCase("pong")) {
                    return jedis;
                }
                jedis.close();
            }
            catch (JedisException ex) {
                if (suppressed == null) {
                    suppressed = ex;
                }
                if (jedis == null) continue;
                jedis.close();
            }
        }
        JedisNoReachableClusterNodeException noReachableNode = new JedisNoReachableClusterNodeException("No reachable node in cluster");
        if (suppressed != null) {
            noReachableNode.addSuppressed(suppressed);
        }
        throw noReachableNode;
    }

    @Override
    public Jedis getConnectionFromSlot(int slot) {
        JedisPool connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        this.renewSlotCache();
        connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }
}

