/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.libraries.jedis.params;

import java.util.ArrayList;
import java.util.Collections;
import me.william278.huskbungeertp.libraries.jedis.Protocol;
import me.william278.huskbungeertp.libraries.jedis.params.Params;

public class RestoreParams
extends Params {
    private boolean replace;
    private boolean absTtl;
    private Long idleTime;
    private Long frequency;

    public static RestoreParams restoreParams() {
        return new RestoreParams();
    }

    public RestoreParams replace() {
        this.replace = true;
        return this;
    }

    public RestoreParams absTtl() {
        this.absTtl = true;
        return this;
    }

    public RestoreParams idleTime(long idleTime) {
        this.idleTime = idleTime;
        return this;
    }

    public RestoreParams frequency(long frequency) {
        this.frequency = frequency;
        return this;
    }

    public byte[][] getByteParams(byte[] key, byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(key);
        Collections.addAll(byteParams, args);
        if (this.replace) {
            byteParams.add(Protocol.Keyword.REPLACE.getRaw());
        }
        if (this.absTtl) {
            byteParams.add(Protocol.Keyword.ABSTTL.getRaw());
        }
        if (this.idleTime != null) {
            byteParams.add(Protocol.Keyword.IDLETIME.getRaw());
            byteParams.add(Protocol.toByteArray(this.idleTime));
        }
        if (this.frequency != null) {
            byteParams.add(Protocol.Keyword.FREQ.getRaw());
            byteParams.add(Protocol.toByteArray(this.frequency));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

