/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.libraries.minedown;

import java.util.Map;
import me.william278.huskbungeertp.libraries.minedown.MineDownParser;
import me.william278.huskbungeertp.libraries.minedown.MineDownStringifier;
import me.william278.huskbungeertp.libraries.minedown.Replacer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;

public class MineDown {
    public static final String FONT_PREFIX = "font=";
    public static final String COLOR_PREFIX = "color=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String HOVER_PREFIX = "hover=";
    public static final String INSERTION_PREFIX = "insert=";
    private String message;
    private final Replacer replacer = new Replacer();
    private final MineDownParser parser = new MineDownParser();
    private BaseComponent[] baseComponents = null;
    private boolean replaceFirst = false;

    public MineDown(String message) {
        this.message = message;
    }

    public static BaseComponent[] parse(String message, String ... replacements) {
        return new MineDown(message).replace(replacements).toComponent();
    }

    public static String stringify(BaseComponent[] components) {
        return new MineDownStringifier().stringify(components);
    }

    public BaseComponent[] toComponent() {
        if (this.baseComponents() == null) {
            if (this.replaceFirst()) {
                Replacer componentReplacer = new Replacer();
                for (Map.Entry<String, BaseComponent[]> entry : this.replacer().componentReplacements().entrySet()) {
                    componentReplacer.replace(entry.getKey(), MineDown.stringify(entry.getValue()));
                }
                this.baseComponents = this.parser().parse(componentReplacer.replaceIn(this.replacer().replaceIn(this.message()))).create();
            } else {
                this.baseComponents = this.replacer().replaceIn(this.parser().parse(this.message()).create());
            }
        }
        return this.baseComponents();
    }

    private void reset() {
        this.baseComponents = null;
    }

    public MineDown replaceFirst(boolean replaceFirst) {
        this.reset();
        this.replaceFirst = replaceFirst;
        return this;
    }

    public boolean replaceFirst() {
        return this.replaceFirst;
    }

    public MineDown replace(String ... replacements) {
        this.reset();
        this.replacer().replace(replacements);
        return this;
    }

    public MineDown replace(Map<String, ?> replacements) {
        this.reset();
        this.replacer().replace(replacements);
        return this;
    }

    public MineDown replace(String placeholder, BaseComponent ... replacement) {
        this.reset();
        this.replacer().replace(placeholder, replacement);
        return this;
    }

    public MineDown placeholderIndicator(String placeholderIndicator) {
        this.placeholderPrefix(placeholderIndicator);
        this.placeholderSuffix(placeholderIndicator);
        return this;
    }

    public MineDown placeholderPrefix(String placeholderPrefix) {
        this.reset();
        this.replacer().placeholderPrefix(placeholderPrefix);
        return this;
    }

    public String placeholderPrefix() {
        return this.replacer().placeholderPrefix();
    }

    public MineDown placeholderSuffix(String placeholderSuffix) {
        this.reset();
        this.replacer().placeholderSuffix(placeholderSuffix);
        return this;
    }

    public String placeholderSuffix() {
        return this.replacer().placeholderSuffix();
    }

    public MineDown ignorePlaceholderCase(boolean ignorePlaceholderCase) {
        this.reset();
        this.replacer().ignorePlaceholderCase(ignorePlaceholderCase);
        return this;
    }

    public boolean ignorePlaceholderCase() {
        return this.replacer().ignorePlaceholderCase();
    }

    @Deprecated
    public MineDown translateLegacyColors(boolean translateLegacyColors) {
        this.reset();
        this.parser().translateLegacyColors(translateLegacyColors);
        return this;
    }

    public MineDown urlDetection(boolean enabled) {
        this.reset();
        this.parser().urlDetection(enabled);
        return this;
    }

    public MineDown autoAddUrlPrefix(boolean enabled) {
        this.reset();
        this.parser().autoAddUrlPrefix(enabled);
        return this;
    }

    public MineDown urlHoverText(String text) {
        this.reset();
        this.parser().urlHoverText(text);
        return this;
    }

    public MineDown hoverTextWidth(int hoverTextWidth) {
        this.reset();
        this.parser().hoverTextWidth(hoverTextWidth);
        return this;
    }

    public MineDown enable(MineDownParser.Option option) {
        this.reset();
        this.parser().enable(option);
        return this;
    }

    public MineDown disable(MineDownParser.Option option) {
        this.reset();
        this.parser().disable(option);
        return this;
    }

    public MineDown filter(MineDownParser.Option option) {
        this.reset();
        this.parser().filter(option);
        return this;
    }

    public MineDown unfilter(MineDownParser.Option option) {
        this.reset();
        this.parser().unfilter(option);
        return this;
    }

    public MineDown colorChar(char colorChar) {
        this.reset();
        this.parser().colorChar(colorChar);
        return this;
    }

    public String message() {
        return this.message;
    }

    public MineDown message(String message) {
        this.message = message;
        this.reset();
        return this;
    }

    public Replacer replacer() {
        return this.replacer;
    }

    public MineDownParser parser() {
        return this.parser;
    }

    protected BaseComponent[] baseComponents() {
        return this.baseComponents;
    }

    public MineDown copy() {
        return new MineDown(this.message()).copy(this);
    }

    public MineDown copy(MineDown from) {
        this.replacer().copy(from.replacer());
        this.parser().copy(from.parser());
        return this;
    }

    public static String getFormatString(ChatColor format) {
        if (format == ChatColor.BOLD) {
            return "**";
        }
        if (format == ChatColor.ITALIC) {
            return "##";
        }
        if (format == ChatColor.UNDERLINE) {
            return "__";
        }
        if (format == ChatColor.STRIKETHROUGH) {
            return "~~";
        }
        if (format == ChatColor.MAGIC) {
            return "??";
        }
        return "";
    }

    public static ChatColor getFormatFromChar(char c) {
        switch (c) {
            case '~': {
                return ChatColor.STRIKETHROUGH;
            }
            case '_': {
                return ChatColor.UNDERLINE;
            }
            case '*': {
                return ChatColor.BOLD;
            }
            case '#': {
                return ChatColor.ITALIC;
            }
            case '?': {
                return ChatColor.MAGIC;
            }
        }
        return null;
    }

    public static String escape(String string) {
        return new MineDown(string).parser().escape(string);
    }
}

