/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.config.Group;
import me.william278.huskbungeertp.mysql.Database;
import me.william278.huskbungeertp.mysql.MySQL;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DataHandler {
    private static HuskBungeeRTP plugin;
    private static Database database;

    private static Connection getConnection() throws SQLException {
        return database.getConnection();
    }

    public static void loadDatabase(HuskBungeeRTP instance) {
        database = new MySQL(instance);
        database.load();
        plugin = instance;
    }

    public static void closeDatabase() {
        database.close();
    }

    public static void addPlayerIfNotExist(UUID uuid) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            block20: {
                try (Connection connection = DataHandler.getConnection();
                     PreparedStatement checkIfPlayerExist = connection.prepareStatement("SELECT * FROM " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " WHERE `user_uuid`=? LIMIT 1;");){
                    checkIfPlayerExist.setString(1, uuid.toString());
                    ResultSet playerExistResultSet = checkIfPlayerExist.executeQuery();
                    if (playerExistResultSet.next()) break block20;
                    try (PreparedStatement createPlayerStatement = connection.prepareStatement("INSERT INTO " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " (`user_uuid`) VALUES (?)");){
                        createPlayerStatement.setString(1, uuid.toString());
                        createPlayerStatement.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.SEVERE, "An SQL exception has occurred adding a player", e);
                }
            }
        });
    }

    public static CoolDownResponse getPlayerCoolDown(UUID uuid, Group group) {
        long coolDownTimeLeft;
        boolean isPlayerOnCoolDown;
        block21: {
            isPlayerOnCoolDown = false;
            coolDownTimeLeft = 0L;
            try (Connection connection = DataHandler.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + group.getGroupDatabaseTableName() + " WHERE `player_id`=(SELECT `id` FROM " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " WHERE `user_uuid`=? LIMIT 1) LIMIT 1;");){
                preparedStatement.setString(1, uuid.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block21;
                Timestamp lastRtpTimestamp = resultSet.getTimestamp("last_rtp");
                coolDownTimeLeft = lastRtpTimestamp.toInstant().getEpochSecond() + 60L * (long)group.coolDownTimeMinutes() - Instant.now().getEpochSecond();
                if (coolDownTimeLeft <= 0L) {
                    try (PreparedStatement deletePlayerCoolDownStatement = connection.prepareStatement("DELETE FROM " + group.getGroupDatabaseTableName() + " WHERE `player_id`=(SELECT `id` FROM " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " WHERE `user_uuid`=? LIMIT 1) LIMIT 1;");){
                        deletePlayerCoolDownStatement.setString(1, uuid.toString());
                        deletePlayerCoolDownStatement.executeUpdate();
                        break block21;
                    }
                }
                isPlayerOnCoolDown = true;
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception has occurred returning player cooldown data", e);
            }
        }
        return new CoolDownResponse(isPlayerOnCoolDown, coolDownTimeLeft);
    }

    public static TeleportationPoint getPlayerLastRtpPosition(UUID uuid, Group group) {
        TeleportationPoint point = null;
        try (Connection connection = DataHandler.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + group.getGroupDatabaseTableName() + " WHERE `player_id`=(SELECT `id` FROM " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " WHERE `user_uuid`=? LIMIT 1) LIMIT 1;");){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                point = new TeleportationPoint(resultSet.getString("dest_world"), resultSet.getDouble("dest_x"), resultSet.getDouble("dest_y"), resultSet.getDouble("dest_z"), 0.0f, 0.0f, resultSet.getString("dest_server"));
            }
        }
        catch (SQLException e) {
            plugin.getLogger().log(Level.SEVERE, "An SQL exception has occurred returning last RTP position data", e);
        }
        return point;
    }

    public static void setPlayerOnCoolDown(UUID uuid, Group group, TeleportationPoint point) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            block26: {
                try (Connection connection = DataHandler.getConnection();
                     PreparedStatement isPlayerNotAlreadySetCheck = connection.prepareStatement("SELECT * FROM " + group.getGroupDatabaseTableName() + " WHERE `player_id`=(SELECT `id` FROM " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " WHERE `user_uuid`=?);");){
                    isPlayerNotAlreadySetCheck.setString(1, uuid.toString());
                    ResultSet playerSetResultSet = isPlayerNotAlreadySetCheck.executeQuery();
                    if (playerSetResultSet.next()) break block26;
                    try (PreparedStatement getPlayerIdStatement = connection.prepareStatement("SELECT * FROM " + HuskBungeeRTP.getSettings().getDatabasePlayerTableName() + " WHERE `user_uuid`=? LIMIT 1;");){
                        getPlayerIdStatement.setString(1, uuid.toString());
                        ResultSet playerIdSet = getPlayerIdStatement.executeQuery();
                        if (!playerIdSet.next()) break block26;
                        int playerId = playerIdSet.getInt("id");
                        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + group.getGroupDatabaseTableName() + " (`player_id`,`dest_world`,`dest_x`,`dest_y`,`dest_z`,`dest_server`) VALUES(?,?,?,?,?,?);");){
                            preparedStatement.setInt(1, playerId);
                            preparedStatement.setString(2, point.getWorldName());
                            preparedStatement.setDouble(3, point.getX());
                            preparedStatement.setDouble(4, point.getY());
                            preparedStatement.setDouble(5, point.getZ());
                            preparedStatement.setString(6, point.getServer());
                            preparedStatement.executeUpdate();
                        }
                    }
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.SEVERE, "An SQL exception has occurred updating player cooldown data", e);
                }
            }
        });
    }

    public record CoolDownResponse(boolean isInCoolDown, long timeLeft) {
    }
}

