/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskbungeertp.randomtp;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import me.william278.huskbungeertp.HuskBungeeRTP;
import me.william278.huskbungeertp.HuskHomesExecutor;
import me.william278.huskbungeertp.MessageManager;
import me.william278.huskbungeertp.config.Group;
import me.william278.huskbungeertp.jedis.RedisMessage;
import me.william278.huskbungeertp.jedis.RedisMessenger;
import me.william278.huskbungeertp.mysql.DataHandler;
import me.william278.huskbungeertp.plan.PlanDataManager;
import me.william278.huskbungeertp.randomtp.RtpProfile;
import me.william278.huskbungeertp.randomtp.processor.AbstractRtp;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RtpHandler {
    private static final HuskBungeeRTP plugin = HuskBungeeRTP.getInstance();
    public static HashSet<ProcessingRandomTeleport> rtpUsers = new HashSet();

    public static boolean isPlayerRtpProcessing(UUID uuid) {
        HashSet<ProcessingRandomTeleport> teleports = new HashSet<ProcessingRandomTeleport>(rtpUsers);
        for (ProcessingRandomTeleport teleport : teleports) {
            if (!teleport.uuid.equals(uuid)) continue;
            if (teleport.hasTimedOut()) {
                RtpHandler.removeRtpUser(uuid);
                return false;
            }
            return true;
        }
        return false;
    }

    public static void removeRtpUser(UUID uuid) {
        HashSet<ProcessingRandomTeleport> teleports = new HashSet<ProcessingRandomTeleport>(rtpUsers);
        for (ProcessingRandomTeleport teleport : teleports) {
            if (!teleport.uuid.equals(uuid)) continue;
            rtpUsers.remove(teleport);
            return;
        }
    }

    public static void processRtp(Player player, RtpProfile profile) {
        UUID uuid = player.getUniqueId();
        boolean canBypassCoolDown = player.hasPermission("huskrtp.bypass_cooldown");
        if (RtpHandler.isPlayerRtpProcessing(uuid)) {
            MessageManager.sendMessage((CommandSender)player, "error_already_rtping");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            DataHandler.CoolDownResponse coolDownResponse = DataHandler.getPlayerCoolDown(player.getUniqueId(), profile.getDestinationGroup());
            if (coolDownResponse.isInCoolDown() && !canBypassCoolDown) {
                TeleportationPoint lastRtpPosition;
                if (HuskBungeeRTP.getSettings().isUseLastRtpLocationOnCoolDown() && (lastRtpPosition = DataHandler.getPlayerLastRtpPosition(uuid, profile.getDestinationGroup())) != null) {
                    if (coolDownResponse.timeLeft() <= 60L) {
                        MessageManager.sendMessage((CommandSender)player, "last_rtp_cooldown_seconds", Long.toString(coolDownResponse.timeLeft()));
                    } else {
                        MessageManager.sendMessage((CommandSender)player, "last_rtp_cooldown_minutes", Integer.toString((int)(coolDownResponse.timeLeft() / 60L)));
                    }
                    HuskHomesExecutor.teleportPlayer(player, lastRtpPosition);
                    return;
                }
                if (coolDownResponse.timeLeft() <= 60L) {
                    MessageManager.sendMessage((CommandSender)player, "error_cooldown_seconds", Long.toString(coolDownResponse.timeLeft()));
                } else {
                    MessageManager.sendMessage((CommandSender)player, "error_cooldown_minutes", Integer.toString((int)(coolDownResponse.timeLeft() / 60L)));
                }
                return;
            }
            MessageManager.sendMessage((CommandSender)player, "processing_rtp");
            rtpUsers.add(new ProcessingRandomTeleport(uuid));
            Group.Server targetServer = RtpHandler.determineTargetServer(profile.getDestinationGroup().getServers());
            String targetWorld = RtpHandler.determineTargetWorld(targetServer);
            String targetBiome = "ALL";
            Biome profileTargetBiome = profile.getTargetBiome();
            if (profileTargetBiome != null) {
                targetBiome = profileTargetBiome.toString();
            }
            if (targetServer.getName().equals(HuskBungeeRTP.getSettings().getServerId())) {
                String finalTargetBiome = targetBiome;
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                    AbstractRtp.RandomResult result;
                    World targetLocalWorld = Bukkit.getWorld((String)targetWorld);
                    if (targetLocalWorld == null) {
                        targetLocalWorld = player.getWorld();
                    }
                    if (!(result = HuskBungeeRTP.getAbstractRtp().getRandomLocation(targetLocalWorld, finalTargetBiome)).successful()) {
                        MessageManager.sendMessage((CommandSender)player, "error_rtp_failed", Integer.toString(result.attemptsTaken()));
                        RtpHandler.removeRtpUser(uuid);
                        return;
                    }
                    TeleportationPoint targetPoint = new TeleportationPoint(result.location(), targetServer.getName());
                    HuskHomesExecutor.teleportPlayer(player, targetPoint);
                    RtpHandler.removeRtpUser(uuid);
                    if (!canBypassCoolDown) {
                        DataHandler.setPlayerOnCoolDown(uuid, profile.getDestinationGroup(), targetPoint);
                    }
                });
            } else {
                RedisMessenger.publish(new RedisMessage(targetServer.getName(), RedisMessage.RedisMessageType.REQUEST_RANDOM_LOCATION, uuid + "#" + HuskBungeeRTP.getSettings().getServerId() + "#" + targetWorld + "#" + targetBiome + "#" + profile.getDestinationGroup().getGroupId()));
            }
        });
    }

    private static Group.Server determineTargetServer(HashSet<Group.Server> servers) {
        HashSet<Group.Server> possibleTargets = new HashSet<Group.Server>(servers);
        switch (HuskBungeeRTP.getSettings().getLoadBalancingMethod()) {
            case PLAN: {
                if (!PlanDataManager.usePlanIntegration()) break;
                PlanDataManager.fetchPlanIfNeeded();
                HashSet<String> targetServerIds = PlanDataManager.getServerIdsWithLowestPlayTime(servers);
                possibleTargets.clear();
                block4: for (Group.Server server : servers) {
                    for (String serverId : targetServerIds) {
                        if (!server.getName().equals(serverId)) continue;
                        possibleTargets.add(server);
                        continue block4;
                    }
                }
                break;
            }
            case PLAYER_COUNTS: {
                HuskBungeeRTP.updateServerPlayerCounts();
                HashSet<String> targetServerIds = HuskBungeeRTP.getServerIdsWithFewestPlayers(servers);
                possibleTargets.clear();
                block6: for (Group.Server server : servers) {
                    for (String serverId : targetServerIds) {
                        if (!server.getName().equals(serverId)) continue;
                        possibleTargets.add(server);
                        continue block6;
                    }
                }
                break;
            }
        }
        ArrayList<Group.Server> shuffledServers = new ArrayList<Group.Server>(possibleTargets);
        Collections.shuffle(shuffledServers);
        return shuffledServers.get(0);
    }

    private static String determineTargetWorld(Group.Server server) {
        ArrayList<String> worlds = new ArrayList<String>(server.getWorlds());
        Collections.shuffle(worlds);
        return worlds.get(0);
    }

    public static class ProcessingRandomTeleport {
        private final long timeOutTime;
        public final UUID uuid;

        public ProcessingRandomTeleport(UUID uuid) {
            this.uuid = uuid;
            this.timeOutTime = Instant.now().getEpochSecond() + (long)HuskBungeeRTP.getSettings().getRtpTimeOutSeconds();
        }

        public boolean hasTimedOut() {
            return Instant.now().getEpochSecond() >= this.timeOutTime;
        }
    }
}

