/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord.listener;

import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import net.william278.huskchat.bungeecord.HuskChatBungee;
import net.william278.huskchat.bungeecord.player.BungeePlayer;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.listener.PlayerListener;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.player.PlayerCache;

public class BungeeListener
extends PlayerListener
implements Listener {
    private static final HuskChatBungee plugin = HuskChatBungee.getInstance();

    @EventHandler(priority=32)
    public void onPlayerChat(ChatEvent e) {
        if (e.isCommand() || e.isProxyCommand() || e.isCancelled()) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)e.getSender();
        Channel channel = Settings.channels.get(PlayerCache.getPlayerChannel(player.getUniqueId()));
        if (channel.broadcastScope.isPassThrough) {
            if (!ChatMessage.passesFilters(plugin, BungeePlayer.adaptCrossPlatform(player), new StringBuilder(e.getMessage()), channel)) {
                e.setCancelled(true);
            }
            return;
        }
        e.setCancelled(true);
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)plugin, () -> new ChatMessage(PlayerCache.getPlayerChannel(player.getUniqueId()), BungeePlayer.adaptCrossPlatform(player), e.getMessage(), plugin).dispatch());
    }

    @EventHandler(priority=32)
    public void onPlayerChangeServer(ServerConnectedEvent e) {
        String server = e.getServer().getInfo().getName();
        BungeePlayer player = BungeePlayer.adaptCrossPlatform(e.getPlayer());
        this.handlePlayerSwitchServer(player, server, plugin);
    }
}

