/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord.message;

import dev.dejvokep.boostedyaml.YamlDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.william278.huskchat.bungeecord.HuskChatBungee;
import net.william278.huskchat.bungeecord.player.BungeePlayer;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.minedown.MineDown;
import net.william278.huskchat.libraries.minedown.MineDownParser;
import net.william278.huskchat.message.MessageManager;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.util.PlaceholderReplacer;

public class BungeeMessageManager
extends MessageManager {
    private static final HuskChatBungee plugin = HuskChatBungee.getInstance();

    public BungeeMessageManager() throws IOException {
        super(YamlDocument.create(new File(plugin.getDataFolder(), "messages-" + Settings.language + ".yml"), plugin.getResourceAsStream("languages/" + Settings.language + ".yml")));
    }

    @Override
    public void sendMessage(Player player, String messageId, String ... placeholderReplacements) {
        String message = this.getRawMessage(messageId);
        if (message == null) {
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        int replacementIndexer = 1;
        for (String replacement : placeholderReplacements) {
            String replacementString = "%" + replacementIndexer + "%";
            message = message.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        String finalMessage = message;
        BungeePlayer.adaptBungee(player).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(new MineDown(finalMessage).replace(new String[0]).toComponent()));
    }

    @Override
    public void sendMessage(Player player, String messageId) {
        String message = this.getRawMessage(messageId);
        if (message == null) {
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        BungeePlayer.adaptBungee(player).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(new MineDown(message).replace(new String[0]).toComponent()));
    }

    @Override
    public void sendCustomMessage(Player player, String message) {
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        BungeePlayer.adaptBungee(player).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(new MineDown(message).replace(new String[0]).toComponent()));
    }

    @Override
    public void sendFormattedChannelMessage(Player target, Player sender, Channel channel, String message) {
        ComponentBuilder componentBuilder = new ComponentBuilder();
        componentBuilder.append(new MineDown(PlaceholderReplacer.replace(sender, channel.format, plugin)).toComponent());
        if (sender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append(message);
        }
        BungeePlayer.adaptBungee(target).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(componentBuilder.create()));
    }

    @Override
    public void sendFormattedOutboundPrivateMessage(Player messageSender, ArrayList<Player> messageRecipients, String message) {
        ComponentBuilder componentBuilder = new ComponentBuilder();
        if (messageRecipients.size() == 1) {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageRecipients.get(0), Settings.outboundMessageFormat, plugin)).toComponent());
        } else {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageRecipients.get(0), Settings.groupOutboundMessageFormat, plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(messageRecipients.size() - 1)).replace("%group_amount%", Integer.toString(messageRecipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(messageRecipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(messageRecipients, "\n")))).toComponent());
        }
        if (messageSender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append(message);
        }
        if (messageSender instanceof ConsolePlayer) {
            plugin.getProxy().getConsole().sendMessage(componentBuilder.create());
            return;
        }
        BungeePlayer.adaptBungee(messageSender).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(componentBuilder.create()));
    }

    @Override
    public void sendFormattedInboundPrivateMessage(ArrayList<Player> messageRecipients, Player messageSender, String message) {
        ComponentBuilder componentBuilder = new ComponentBuilder();
        if (messageRecipients.size() == 1) {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageSender, Settings.inboundMessageFormat, plugin)).toComponent());
        } else {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageSender, Settings.groupInboundMessageFormat, plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(messageRecipients.size() - 1)).replace("%group_amount%", Integer.toString(messageRecipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(messageRecipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(messageRecipients, "\n")))).toComponent());
        }
        if (messageSender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append(message);
        }
        for (Player recipient : messageRecipients) {
            if (recipient instanceof ConsolePlayer) {
                plugin.getProxy().getConsole().sendMessage(componentBuilder.create());
                continue;
            }
            BungeePlayer.adaptBungee(recipient).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(componentBuilder.create()));
        }
    }

    @Override
    public void sendFormattedLocalSpyMessage(Player spy, PlayerCache.SpyColor spyColor, Player sender, Channel channel, String message) {
        ComponentBuilder componentBuilder = new ComponentBuilder().append(new MineDown(PlaceholderReplacer.replace(sender, Settings.localSpyFormat, plugin).replace("%spy_color%", spyColor.colorCode)).toComponent()).append(message);
        BungeePlayer.adaptBungee(spy).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(componentBuilder.create()));
    }

    @Override
    public void sendFormattedSocialSpyMessage(Player spy, PlayerCache.SpyColor spyColor, Player sender, ArrayList<Player> receivers, String message) {
        ComponentBuilder componentBuilder = new ComponentBuilder();
        if (receivers.size() == 1) {
            Player receiver = receivers.get(0);
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(receiver, PlaceholderReplacer.replace(sender, Settings.socialSpyFormat.replace("%sender_", "%"), plugin).replace("%receiver_", "%"), plugin).replace("%spy_color%", spyColor.colorCode)).toComponent()).append(message);
        } else {
            Player firstReceiver = receivers.get(0);
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(firstReceiver, PlaceholderReplacer.replace(sender, Settings.socialSpyGroupFormat.replace("%sender_", "%"), plugin).replace("%receiver_", "%"), plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(receivers.size() - 1)).replace("%group_amount%", Integer.toString(receivers.size() - 1)).replace("%group_members%", MineDown.escape(this.getGroupMemberList(receivers, "\n"))).replace("%group_members_comma_separated%", this.getGroupMemberList(receivers, ",")).replace("%spy_color%", spyColor.colorCode)).toComponent()).append(message);
        }
        BungeePlayer.adaptBungee(spy).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(componentBuilder.create()));
    }

    @Override
    public void sendFormattedBroadcastMessage(Player player, String message) {
        ComponentBuilder componentBuilder = new ComponentBuilder();
        componentBuilder.append(new MineDown(Settings.broadcastMessageFormat).toComponent());
        componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        BungeePlayer.adaptBungee(player).ifPresent(bungeePlayer -> bungeePlayer.sendMessage(componentBuilder.create()));
    }

    private void sendMineDownToConsole(String mineDown) {
        plugin.getProxy().getConsole().sendMessage(new MineDown(this.extractMineDownLinks(mineDown)).toComponent());
    }
}

