/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.player.Player;

public class RepeatFilter
extends ChatFilter {
    private final HashMap<UUID, LinkedList<String>> userMessageQueues;
    private final int previousMessagesToCheck;

    public RepeatFilter(int previousMessagesToCheck) {
        this.previousMessagesToCheck = previousMessagesToCheck;
        this.userMessageQueues = new HashMap();
    }

    @Override
    public boolean isAllowed(Player player, String message) {
        if (!this.userMessageQueues.containsKey(player.getUuid())) {
            this.userMessageQueues.put(player.getUuid(), new LinkedList());
        }
        if (!this.userMessageQueues.get(player.getUuid()).isEmpty()) {
            for (String previousMessage : this.userMessageQueues.get(player.getUuid())) {
                if (!message.equalsIgnoreCase(previousMessage)) continue;
                return false;
            }
            if (this.userMessageQueues.get(player.getUuid()).size() + 1 > this.previousMessagesToCheck) {
                this.userMessageQueues.get(player.getUuid()).removeLast();
            }
        }
        this.userMessageQueues.get(player.getUuid()).addFirst(message);
        return true;
    }

    @Override
    public String getFailureErrorMessageId() {
        return "error_chat_filter_repeat";
    }

    @Override
    public String getFilterIgnorePermission() {
        return "huskchat.ignore_filters.spam";
    }
}

