/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.getter;

import java.util.Optional;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.model.user.User;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.player.Player;

public class LuckPermsDataGetter
extends DataGetter {
    private final LuckPerms api = LuckPermsProvider.get();

    @Override
    public String getPlayerFullName(Player player) {
        User user = this.getUser(player.getUuid());
        if (user == null) {
            return player.getName();
        }
        CachedDataManager cachedData = user.getCachedData();
        StringBuilder fullName = new StringBuilder();
        String prefix = cachedData.getMetaData().getPrefix();
        if (prefix != null) {
            fullName.append(prefix);
        }
        fullName.append(player.getName());
        String suffix = cachedData.getMetaData().getSuffix();
        if (suffix != null) {
            fullName.append(suffix);
        }
        return fullName.toString();
    }

    @Override
    public String getPlayerName(Player player) {
        return player.getName();
    }

    @Override
    public Optional<String> getPlayerPrefix(Player player) {
        User user = this.getUser(player.getUuid());
        if (user == null) {
            return Optional.empty();
        }
        String prefix = user.getCachedData().getMetaData().getPrefix();
        if (prefix != null) {
            return Optional.of(prefix);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getPlayerSuffix(Player player) {
        User user = this.getUser(player.getUuid());
        if (user == null) {
            return Optional.empty();
        }
        String suffix = user.getCachedData().getMetaData().getSuffix();
        if (suffix != null) {
            return Optional.of(suffix);
        }
        return Optional.empty();
    }

    private User getUser(UUID uuid) {
        return this.api.getUserManager().getUser(uuid);
    }
}

