/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.regex.Pattern;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.player.Player;

public class AsciiFilter
extends ChatFilter {
    private final Pattern asciiPattern = Pattern.compile("^[\\u0000-\\u007F]*$");

    @Override
    public boolean isAllowed(Player player, String message) {
        return this.asciiPattern.matcher(message).matches();
    }

    @Override
    public String getFailureErrorMessageId() {
        return "error_chat_filter_ascii";
    }

    @Override
    public String getFilterIgnorePermission() {
        return "huskchat.ignore_filters.ascii";
    }
}

