/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.profanitycheckerapi;

import net.william278.huskchat.libraries.profanitycheckerapi.jep.Interpreter;
import net.william278.huskchat.libraries.profanitycheckerapi.jep.MainInterpreter;
import net.william278.huskchat.libraries.profanitycheckerapi.jep.SharedInterpreter;

public class ProfanityChecker
implements AutoCloseable {
    private Interpreter interpreter;

    public ProfanityChecker(String libraryPath) {
        MainInterpreter.setJepLibraryPath(libraryPath);
        this.initialize();
    }

    public ProfanityChecker() {
        this.initialize();
    }

    private void initialize() {
        this.interpreter = new SharedInterpreter();
        this.interpreter.exec("from profanity_check import predict_prob, predict");
    }

    public boolean isTextProfane(String text) {
        this.interpreter.set("text", text);
        return this.interpreter.getValue("predict([text])[0].item()", Integer.class) == 1;
    }

    public double getTextProfanityLikelihood(String text) {
        this.interpreter.set("text", text);
        return this.interpreter.getValue("predict_prob([text])[0].item()", Double.class);
    }

    @Override
    public void close() throws IllegalStateException {
        if (this.interpreter == null) {
            throw new IllegalStateException("The jep interpreter was not initialized");
        }
        this.interpreter.close();
    }

    @Deprecated
    public void dispose() throws IllegalStateException {
        this.close();
    }
}

