/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.profanitycheckerapi.jep;

abstract class AbstractNDArray<T> {
    protected final T data;
    protected final int[] dimensions;
    protected final boolean unsigned;

    protected AbstractNDArray(T t) {
        this(t, false, null);
    }

    protected AbstractNDArray(T t, boolean bl) {
        this(t, bl, null);
    }

    protected AbstractNDArray(T t, int ... nArray) {
        this(t, false, nArray);
    }

    protected AbstractNDArray(T t, boolean bl, int ... nArray) {
        this.validate(t);
        int n = this.getLength(t);
        if (nArray == null) {
            nArray = new int[]{n};
        }
        int n2 = 1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                throw new IllegalArgumentException("Dimensions cannot be negative, received " + nArray[i]);
            }
            n2 *= nArray[i];
        }
        if (n2 != n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("NDArray data length ");
            stringBuilder.append(n);
            stringBuilder.append(" does not match size specified by dimensions [");
            for (int i = 0; i < nArray.length; ++i) {
                stringBuilder.append(nArray[i]);
                if (i >= nArray.length - 1) continue;
                stringBuilder.append(" * ");
            }
            stringBuilder.append("]");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.data = t;
        this.dimensions = nArray;
        this.unsigned = bl;
    }

    protected abstract void validate(T var1);

    protected abstract int getLength(T var1);

    public int[] getDimensions() {
        return this.dimensions;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public T getData() {
        return this.data;
    }
}

