/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity.message;

import dev.dejvokep.boostedyaml.YamlDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.libraries.minedown.adventure.MineDownParser;
import net.william278.huskchat.message.MessageManager;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.util.PlaceholderReplacer;
import net.william278.huskchat.velocity.HuskChatVelocity;
import net.william278.huskchat.velocity.player.VelocityPlayer;

public class VelocityMessageManager
extends MessageManager {
    private static final HuskChatVelocity plugin = HuskChatVelocity.getInstance();

    public VelocityMessageManager() throws IOException {
        super(YamlDocument.create(new File(plugin.getDataFolder(), "messages-" + Settings.language + ".yml"), Objects.requireNonNull(HuskChat.class.getClassLoader().getResourceAsStream("languages/" + Settings.language + ".yml"))));
    }

    @Override
    public void sendMessage(Player player, String messageId, String ... placeholderReplacements) {
        String message = this.getRawMessage(messageId);
        if (message == null) {
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        int replacementIndexer = 1;
        for (String replacement : placeholderReplacements) {
            String replacementString = "%" + replacementIndexer + "%";
            message = message.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        String finalMessage = message;
        VelocityPlayer.adaptVelocity(player).ifPresent(user -> user.sendMessage(new MineDown(finalMessage).toComponent()));
    }

    @Override
    public void sendMessage(Player player, String messageId) {
        String message = this.getRawMessage(messageId);
        if (message == null) {
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        VelocityPlayer.adaptVelocity(player).ifPresent(user -> user.sendMessage(new MineDown(message).toComponent()));
    }

    @Override
    public void sendCustomMessage(Player player, String message) {
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        VelocityPlayer.adaptVelocity(player).ifPresent(user -> user.sendMessage(new MineDown(message).toComponent()));
    }

    @Override
    public void sendFormattedChannelMessage(Player target, Player sender, Channel channel, String message) {
        TextComponent.Builder componentBuilder = (TextComponent.Builder)Component.text().append(new MineDown(PlaceholderReplacer.replace(sender, channel.format, plugin)).toComponent());
        if (sender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append((Component)Component.text((String)message));
        }
        VelocityPlayer.adaptVelocity(target).ifPresent(user -> user.sendMessage((Component)componentBuilder.build()));
    }

    @Override
    public void sendFormattedOutboundPrivateMessage(Player messageSender, ArrayList<Player> messageRecipients, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        if (messageRecipients.size() == 1) {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageRecipients.get(0), Settings.outboundMessageFormat, plugin)).toComponent());
        } else {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageRecipients.get(0), Settings.groupOutboundMessageFormat, plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(messageRecipients.size() - 1)).replace("%group_amount%", Integer.toString(messageRecipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(messageRecipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(messageRecipients, "\n")))).toComponent());
        }
        if (messageSender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append((Component)Component.text((String)message));
        }
        if (messageSender instanceof ConsolePlayer) {
            plugin.getProxyServer().getConsoleCommandSource().sendMessage((ComponentLike)componentBuilder);
            return;
        }
        VelocityPlayer.adaptVelocity(messageSender).ifPresent(bungeePlayer -> bungeePlayer.sendMessage((ComponentLike)componentBuilder));
    }

    @Override
    public void sendFormattedInboundPrivateMessage(ArrayList<Player> messageRecipients, Player messageSender, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        if (messageRecipients.size() == 1) {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageSender, Settings.inboundMessageFormat, plugin)).toComponent());
        } else {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageSender, Settings.groupInboundMessageFormat, plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(messageRecipients.size() - 1)).replace("%group_amount%", Integer.toString(messageRecipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(messageRecipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(messageRecipients, "\n")))).toComponent());
        }
        if (messageSender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append((Component)Component.text((String)message));
        }
        for (Player recipient : messageRecipients) {
            if (recipient instanceof ConsolePlayer) {
                plugin.getProxyServer().getConsoleCommandSource().sendMessage((ComponentLike)componentBuilder);
                continue;
            }
            VelocityPlayer.adaptVelocity(recipient).ifPresent(bungeePlayer -> bungeePlayer.sendMessage((ComponentLike)componentBuilder));
        }
    }

    @Override
    public void sendFormattedLocalSpyMessage(Player spy, PlayerCache.SpyColor spyColor, Player sender, Channel channel, String message) {
        TextComponent.Builder componentBuilder = (TextComponent.Builder)Component.text().append(new MineDown(PlaceholderReplacer.replace(sender, Settings.localSpyFormat, plugin).replace("%spy_color%", spyColor.colorCode) + MineDown.escape(message)).toComponent());
        VelocityPlayer.adaptVelocity(spy).ifPresent(user -> user.sendMessage((Component)componentBuilder.build()));
    }

    @Override
    public void sendFormattedSocialSpyMessage(Player spy, PlayerCache.SpyColor spyColor, Player sender, ArrayList<Player> receivers, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        if (receivers.size() == 1) {
            Player receiver = receivers.get(0);
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(receiver, PlaceholderReplacer.replace(sender, Settings.socialSpyFormat.replace("%sender_", "%"), plugin).replace("%receiver_", "%"), plugin).replace("%spy_color%", spyColor.colorCode) + MineDown.escape(message)).toComponent());
        } else {
            Player firstReceiver = receivers.get(0);
            String md = PlaceholderReplacer.replace(firstReceiver, PlaceholderReplacer.replace(sender, Settings.socialSpyGroupFormat.replace("%sender_", "%"), plugin).replace("%receiver_", "%"), plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(receivers.size() - 1)).replace("%group_amount%", Integer.toString(receivers.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(receivers, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(receivers, "\n"))).replace("%spy_color%", spyColor.colorCode) + MineDown.escape(message);
            componentBuilder.append(new MineDown(md).toComponent());
        }
        VelocityPlayer.adaptVelocity(spy).ifPresent(bungeePlayer -> bungeePlayer.sendMessage((ComponentLike)componentBuilder));
    }

    @Override
    public void sendFormattedBroadcastMessage(Player player, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        componentBuilder.append(new MineDown(Settings.broadcastMessageFormat).toComponent());
        componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        VelocityPlayer.adaptVelocity(player).ifPresent(user -> user.sendMessage((Component)componentBuilder.build()));
    }

    private void sendMineDownToConsole(String mineDown) {
        plugin.getProxyServer().getConsoleCommandSource().sendMessage(new MineDown(this.extractMineDownLinks(mineDown)).toComponent());
    }
}

