/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.bungeecord.command.BungeeCommand;
import net.william278.huskchat.bungeecord.event.BungeeEventDispatcher;
import net.william278.huskchat.bungeecord.listener.BungeeListener;
import net.william278.huskchat.bungeecord.message.BungeeMessageManager;
import net.william278.huskchat.bungeecord.player.BungeePlayer;
import net.william278.huskchat.bungeecord.util.BungeeLogger;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.LocalSpyCommand;
import net.william278.huskchat.command.MsgCommand;
import net.william278.huskchat.command.OptOutMsgCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.WebhookDispatcher;
import net.william278.huskchat.getter.BungeePermsDataGetter;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.bstats.bungeecord.Metrics;
import net.william278.huskchat.message.MessageManager;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.util.Logger;
import org.jetbrains.annotations.NotNull;

public final class HuskChatBungee
extends Plugin
implements HuskChat {
    private static final int METRICS_ID = 11882;
    private static HuskChatBungee instance;
    private static BungeeEventDispatcher eventDispatcher;
    private static WebhookDispatcher webhookDispatcher;
    public static BungeeMessageManager messageManager;
    public static DataGetter playerDataGetter;

    public static HuskChatBungee getInstance() {
        return instance;
    }

    @Override
    @NotNull
    public BungeeEventDispatcher getEventDispatcher() {
        return eventDispatcher;
    }

    @Override
    public Optional<WebhookDispatcher> getWebhookDispatcher() {
        if (webhookDispatcher != null) {
            return Optional.of(webhookDispatcher);
        }
        return Optional.empty();
    }

    public void onLoad() {
        instance = this;
        eventDispatcher = new BungeeEventDispatcher(this.getProxy());
    }

    public void onEnable() {
        Plugin bungeePerms;
        this.reloadSettings();
        this.reloadMessages();
        PlayerCache.setDataFolder(this.getDataFolder());
        try {
            PlayerCache.loadSpy();
        }
        catch (IOException e) {
            this.getLoggingAdapter().log(Level.SEVERE, "Failed to load spies file");
        }
        Plugin luckPerms = ProxyServer.getInstance().getPluginManager().getPlugin("LuckPerms");
        playerDataGetter = luckPerms != null ? new LuckPermsDataGetter() : ((bungeePerms = ProxyServer.getInstance().getPluginManager().getPlugin("BungeePerms")) != null ? new BungeePermsDataGetter() : new DefaultDataGetter());
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeListener());
        new BungeeCommand(new HuskChatCommand(this));
        new BungeeCommand(new ChannelCommand(this));
        if (Settings.doMessageCommand) {
            new BungeeCommand(new MsgCommand(this));
            new BungeeCommand(new ReplyCommand(this));
            new BungeeCommand(new OptOutMsgCommand(this));
        }
        if (Settings.doBroadcastCommand) {
            new BungeeCommand(new BroadcastCommand(this));
        }
        if (Settings.doSocialSpyCommand) {
            new BungeeCommand(new SocialSpyCommand(this));
        }
        if (Settings.doLocalSpyCommand) {
            new BungeeCommand(new LocalSpyCommand(this));
        }
        Settings.channels.forEach((id, channel) -> {
            for (String command : channel.shortcutCommands) {
                new BungeeCommand(new ShortcutCommand(command, channel.id, this));
            }
        });
        if (Settings.doDiscordIntegration) {
            webhookDispatcher = new WebhookDispatcher(Settings.webhookUrls);
        }
        new Metrics(this, 11882);
        this.getLoggingAdapter().info("Enabled HuskChat version " + this.getDescription().getVersion());
    }

    public void onDisable() {
        this.getLoggingAdapter().info("Disabled HuskChat version " + this.getDescription().getVersion());
    }

    @Override
    public void reloadMessages() {
        try {
            messageManager = new BungeeMessageManager();
        }
        catch (IOException e) {
            this.getLoggingAdapter().log(Level.SEVERE, "Failed to load messages file");
        }
    }

    @Override
    @NotNull
    public MessageManager getMessageManager() {
        return messageManager;
    }

    @Override
    public void reloadSettings() {
        try {
            Settings.load(YamlDocument.create(new File(this.getDataFolder(), "config.yml"), this.getResourceAsStream("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.builder().setEncoding(DumperSettings.Encoding.UNICODE).build(), UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build()));
        }
        catch (IOException e) {
            this.getLoggingAdapter().log(Level.SEVERE, "Failed to load config file");
        }
    }

    @Override
    @NotNull
    public String getMetaVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    @NotNull
    public String getMetaDescription() {
        return this.getDescription().getDescription();
    }

    @Override
    @NotNull
    public String getMetaPlatform() {
        return ProxyServer.getInstance().getName();
    }

    @Override
    public DataGetter getDataGetter() {
        return playerDataGetter;
    }

    @Override
    public Optional<Player> getPlayer(UUID uuid) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null) {
            return Optional.of(BungeePlayer.adaptCrossPlatform(player));
        }
        return Optional.empty();
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        ArrayList<Player> crossPlatform = new ArrayList<Player>();
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            crossPlatform.add(BungeePlayer.adaptCrossPlatform(player));
        }
        return crossPlatform;
    }

    @Override
    public Collection<Player> getOnlinePlayersOnServer(Player player) {
        ArrayList<Player> crossPlatform = new ArrayList<Player>();
        BungeePlayer.adaptBungee(player).ifPresent(bungeePlayer -> {
            for (ProxiedPlayer playerOnServer : bungeePlayer.getServer().getInfo().getPlayers()) {
                crossPlatform.add(BungeePlayer.adaptCrossPlatform(playerOnServer));
            }
        });
        return crossPlatform;
    }

    @Override
    @NotNull
    public Logger getLoggingAdapter() {
        return BungeeLogger.get();
    }

    @Override
    public Optional<Player> matchPlayer(String username) {
        Optional<Player> optionalPlayer;
        if (username.isEmpty()) {
            return Optional.empty();
        }
        if (ProxyServer.getInstance().getPlayer(username) != null) {
            ProxiedPlayer player = ProxyServer.getInstance().getPlayer(username);
            optionalPlayer = Optional.of(BungeePlayer.adaptCrossPlatform(player));
        } else {
            List<ProxiedPlayer> matchedPlayers = ProxyServer.getInstance().matchPlayer(username).stream().filter(val -> val.getName().startsWith(username)).sorted().toList();
            optionalPlayer = matchedPlayers.size() > 0 ? Optional.of(BungeePlayer.adaptCrossPlatform(matchedPlayers.get(0))) : Optional.empty();
        }
        return optionalPlayer;
    }
}

