/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord.player;

import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.william278.huskchat.player.Player;

public class BungeePlayer
implements Player {
    private ProxiedPlayer player;

    private BungeePlayer() {
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public UUID getUuid() {
        return this.player.getUniqueId();
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }

    @Override
    public String getServerName() {
        return this.player.getServer().getInfo().getName();
    }

    @Override
    public int getPlayersOnServer() {
        return this.player.getServer().getInfo().getPlayers().size();
    }

    @Override
    public boolean hasPermission(String s) {
        return this.player.hasPermission(s);
    }

    public static Optional<ProxiedPlayer> adaptBungee(Player player) {
        ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(player.getUuid());
        if (proxiedPlayer != null) {
            return Optional.of(proxiedPlayer);
        }
        return Optional.empty();
    }

    public static BungeePlayer adaptCrossPlatform(ProxiedPlayer player) {
        BungeePlayer bungeePlayer = new BungeePlayer();
        bungeePlayer.player = player;
        return bungeePlayer;
    }
}

