/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class ChannelCommand
extends CommandBase {
    private static final String PERMISSION = "huskchat.command.channel";

    public ChannelCommand(HuskChat implementor) {
        super(Settings.channelCommandAliases.get(0), PERMISSION, implementor, Settings.getAliases(Settings.channelCommandAliases));
    }

    @Override
    public void onExecute(Player player, String[] args) {
        if (player instanceof ConsolePlayer) {
            this.implementor.getLoggingAdapter().log(Level.INFO, this.implementor.getMessageManager().getRawMessage("error_in_game_only"));
            return;
        }
        if (player.hasPermission(this.permission)) {
            if (args.length == 1) {
                PlayerCache.switchPlayerChannel(player, args[0], this.implementor.getMessageManager());
            } else {
                this.implementor.getMessageManager().sendMessage(player, "error_invalid_syntax", "/channel <channel>");
            }
        } else {
            this.implementor.getMessageManager().sendMessage(player, "error_no_permission");
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] args) {
        if (!player.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        if (args.length <= 1) {
            return this.getChannelsIdsWithSendPermission(player).stream().filter(val -> val.toLowerCase().startsWith(args.length >= 1 ? args[0].toLowerCase() : "")).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public HashSet<String> getChannelsIdsWithSendPermission(Player player) {
        HashSet<String> channelsWithPermission = new HashSet<String>();
        Settings.channels.forEach((id, channel) -> {
            if (channel.sendPermission == null || player.hasPermission(channel.sendPermission)) {
                channelsWithPermission.add(channel.id);
            }
        });
        return channelsWithPermission;
    }
}

