/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.player.Player;
import net.william278.profanitycheckerapi.ProfanityChecker;

public class ProfanityFilterer
extends ChatFilter {
    private final double thresholdValue;
    private final ProfanityFilterMode profanityFilterMode;
    private final ProfanityFiltererRunnable profanityFiltererRunnable;

    public ProfanityFilterer(ProfanityFilterMode filterMode, double thresholdValue, String libraryPath) {
        this.thresholdValue = thresholdValue;
        this.profanityFilterMode = filterMode;
        this.profanityFiltererRunnable = new ProfanityFiltererRunnable(libraryPath);
        new Thread(this.profanityFiltererRunnable).start();
    }

    @Override
    public boolean isAllowed(Player player, String message) {
        try {
            return !this.getIsProfane(message);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getFailureErrorMessageId() {
        return "error_chat_filter_profanity";
    }

    @Override
    public String getFilterIgnorePermission() {
        return "huskchat.ignore_filters.profanity";
    }

    private boolean getIsProfane(String message) throws ExecutionException, InterruptedException {
        if (this.profanityFiltererRunnable.threadState == ProfanityFiltererRunnable.ThreadState.TERMINATED) {
            return false;
        }
        return switch (this.profanityFilterMode) {
            case ProfanityFilterMode.AUTOMATIC -> this.profanityFiltererRunnable.calculateIsProfane(message);
            case ProfanityFilterMode.TOLERANCE -> this.profanityFiltererRunnable.calculateIsProfane(message, this.thresholdValue);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public void dispose() {
        this.profanityFiltererRunnable.threadState = ProfanityFiltererRunnable.ThreadState.TERMINATED;
    }

    public static enum ProfanityFilterMode {
        AUTOMATIC,
        TOLERANCE;

    }

    private static class ProfanityFiltererRunnable
    implements Runnable {
        private ProfanityChecker profanityChecker;
        private ThreadState threadState;
        private ProfanityFilterMode profanityFilterMode;
        private String input;
        private CompletableFuture<Object> output;
        private final String libraryPath;

        public ProfanityFiltererRunnable(String libraryPath) {
            this.libraryPath = libraryPath;
        }

        public boolean calculateIsProfane(String text) {
            try {
                return (Boolean)this.calculate(text, ProfanityFilterMode.AUTOMATIC).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return new CompletableFuture<Boolean>().complete(false);
            }
        }

        public boolean calculateIsProfane(String text, double threshold) {
            try {
                return (Double)this.calculate(text, ProfanityFilterMode.TOLERANCE).get() > threshold;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return new CompletableFuture<Boolean>().complete(false);
            }
        }

        private CompletableFuture<Object> calculate(String text, ProfanityFilterMode mode) {
            this.output = new CompletableFuture();
            this.profanityFilterMode = mode;
            this.input = text;
            this.threadState = ThreadState.CALCULATE;
            return this.output;
        }

        @Override
        public void run() {
            try {
                this.profanityChecker = this.libraryPath.isEmpty() ? new ProfanityChecker() : new ProfanityChecker(this.libraryPath);
                this.threadState = ThreadState.ASLEEP;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.out.println("\u001b[1;31m[HuskChat] Error initializing the profanity checking filter: UnsatisfiedLinkError\n\u001b[1;31m\u2022 The profanity checking filter requires Python 3.8+ with the jep and alt-profanity-check dependencies installed on the system.\n\u001b[1;31m\u2022 This error indicates that the plugin was unable to find the necessary jep driver file.\n\u001b[1;31m\u2022 Please ensure the the jep library file path has been set correctly on your system.\n\u001b[1;31m\u2022 Please consult the HuskChat README file for more information on properly setting up the profanity checking filter.\n\u001b[1;31m\u2022 The profanity checking filter has been disabled.\n\u001b[1;31mStack trace:");
                unsatisfiedLinkError.printStackTrace();
                this.threadState = ThreadState.TERMINATED;
            }
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleAtFixedRate(() -> {
                switch (this.threadState) {
                    case CALCULATE: {
                        if (this.profanityFilterMode == ProfanityFilterMode.AUTOMATIC) {
                            this.output.complete(this.profanityChecker.isTextProfane(this.input));
                        } else if (this.profanityFilterMode == ProfanityFilterMode.TOLERANCE) {
                            this.output.complete(this.profanityChecker.getTextProfanityLikelihood(this.input));
                        }
                        this.threadState = ThreadState.ASLEEP;
                        break;
                    }
                    case TERMINATED: {
                        if (this.profanityChecker != null) {
                            this.profanityChecker.close();
                        }
                        executor.shutdown();
                    }
                }
            }, 0L, 20L, TimeUnit.MILLISECONDS);
        }

        public static enum ThreadState {
            ASLEEP,
            CALCULATE,
            TERMINATED;

        }
    }
}

