/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.getter;

import java.util.Optional;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.User;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.player.Player;

public class BungeePermsDataGetter
extends DataGetter {
    private final PermissionsManager permissionsManager = BungeePerms.getInstance().getPermissionsManager();

    @Override
    public String getPlayerFullName(Player player) {
        Optional<String> prefix = this.getPlayerPrefix(player);
        Optional<String> suffix = this.getPlayerSuffix(player);
        return (prefix.isPresent() ? prefix : "") + player.getName() + (suffix.isPresent() ? suffix : "");
    }

    @Override
    public String getPlayerName(Player player) {
        return player.getName();
    }

    @Override
    public Optional<String> getPlayerPrefix(Player player) {
        try {
            return Optional.of(this.permissionsManager.getMainGroup(this.getUser(player)).getPrefix());
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getPlayerSuffix(Player player) {
        try {
            return Optional.of(this.permissionsManager.getMainGroup(this.getUser(player)).getSuffix());
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    private User getUser(Player player) {
        return this.permissionsManager.getUser(player.getUuid());
    }
}

