/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.profanitycheckerapi.jep;

import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import net.william278.huskchat.libraries.profanitycheckerapi.jep.AbstractNDArray;

public class DirectNDArray<T extends Buffer>
extends AbstractNDArray<T> {
    public DirectNDArray(T t) {
        super(t);
    }

    public DirectNDArray(T t, boolean bl) {
        super(t, bl);
    }

    public DirectNDArray(T t, int ... nArray) {
        super(t, nArray);
    }

    public DirectNDArray(T t, boolean bl, int ... nArray) {
        super(t, bl, nArray);
    }

    @Override
    protected void validate(T t) {
        if (!((Buffer)t).isDirect()) {
            throw new IllegalArgumentException("DirectNDArray only supports direct buffers.");
        }
        if (t instanceof CharBuffer) {
            throw new IllegalArgumentException("DirectNDArray only supports numeric primitives, not CharBuffer");
        }
    }

    @Override
    public int getLength(T t) {
        return ((Buffer)t).capacity();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DirectNDArray directNDArray = (DirectNDArray)object;
        if (this.unsigned != directNDArray.unsigned) {
            return false;
        }
        if (!Arrays.equals(this.dimensions, directNDArray.dimensions)) {
            return false;
        }
        if (directNDArray.data == null) {
            return false;
        }
        return ((Buffer)this.data).equals(directNDArray.data);
    }

    public int hashCode() {
        int n = 1;
        n = this.data == null ? 31 * n + 0 : 31 * n + ((Buffer)this.data).hashCode();
        n = 31 * n + Arrays.hashCode(this.dimensions) + (this.unsigned ? 1 : 0);
        return n;
    }
}

