/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.filter.replacer.ReplacerFilter;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class ChatMessage {
    public final String targetChannelId;
    public Player sender;
    public final HuskChat implementor;
    public String message;

    public ChatMessage(String targetChannelId, Player sender, String message, HuskChat implementor) {
        this.targetChannelId = targetChannelId;
        this.sender = sender;
        this.message = message;
        this.implementor = implementor;
    }

    public void dispatch() {
        AtomicReference<Channel> channel = new AtomicReference<Channel>(Settings.channels.get(this.targetChannelId));
        if (channel.get() == null) {
            this.implementor.getMessageManager().sendMessage(this.sender, "error_no_channel");
            return;
        }
        if (channel.get().sendPermission != null && !this.sender.hasPermission(channel.get().sendPermission)) {
            this.implementor.getMessageManager().sendMessage(this.sender, "error_no_permission_send", channel.get().id);
            return;
        }
        for (String restrictedServer : channel.get().restrictedServers) {
            if (!restrictedServer.equalsIgnoreCase(this.sender.getServerName())) continue;
            this.implementor.getMessageManager().sendMessage(this.sender, "error_channel_restricted_server", channel.get().id);
            return;
        }
        Channel.BroadcastScope broadcastScope = channel.get().broadcastScope;
        if (this.sender instanceof ConsolePlayer && (broadcastScope == Channel.BroadcastScope.LOCAL || broadcastScope == Channel.BroadcastScope.LOCAL_PASSTHROUGH)) {
            this.implementor.getLoggingAdapter().log(Level.INFO, this.implementor.getMessageManager().getRawMessage("error_console_local_scope"));
            return;
        }
        StringBuilder msg = new StringBuilder(this.message);
        if (!ChatMessage.passesFilters(this.implementor, this.sender, msg, channel.get())) {
            return;
        }
        this.message = msg.toString();
        HashSet<Player> messageRecipients = new HashSet<Player>();
        switch (broadcastScope) {
            case GLOBAL: 
            case GLOBAL_PASSTHROUGH: {
                messageRecipients.addAll(this.implementor.getOnlinePlayers());
                break;
            }
            case LOCAL: 
            case LOCAL_PASSTHROUGH: {
                messageRecipients.addAll(this.implementor.getOnlinePlayersOnServer(this.sender));
                break;
            }
        }
        this.implementor.getEventDispatcher().dispatchChatMessageEvent(this.sender, this.message, this.targetChannelId).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.sender = event.getSender();
            if (!event.getChannelId().equals(((Channel)channel.get()).id) && Settings.channels.containsKey(event.getChannelId())) {
                channel.set(Settings.channels.get(event.getChannelId()));
            }
            this.message = event.getMessage();
            block2: for (Player recipient : messageRecipients) {
                if (((Channel)channel.get()).receivePermission != null && !recipient.hasPermission(((Channel)channel.get()).receivePermission) && !recipient.getUuid().equals(this.sender.getUuid())) continue;
                for (String restrictedServer : ((Channel)channel.get()).restrictedServers) {
                    if (!restrictedServer.equalsIgnoreCase(recipient.getServerName())) continue;
                    continue block2;
                }
                this.implementor.getMessageManager().sendFormattedChannelMessage(recipient, this.sender, (Channel)channel.get(), this.message);
            }
            if ((broadcastScope == Channel.BroadcastScope.LOCAL || broadcastScope == Channel.BroadcastScope.LOCAL_PASSTHROUGH) && Settings.doLocalSpyCommand && !Settings.isLocalSpyChannelExcluded((Channel)channel.get())) {
                HashMap<Player, PlayerCache.SpyColor> spies = PlayerCache.getLocalSpyMessageReceivers(this.sender.getServerName(), this.implementor);
                for (Player spy : spies.keySet()) {
                    if (spy.getUuid().equals(this.sender.getUuid())) continue;
                    if (!spy.hasPermission("huskchat.command.localspy")) {
                        try {
                            PlayerCache.removeLocalSpy(spy);
                        }
                        catch (IOException e) {
                            this.implementor.getLoggingAdapter().log(Level.SEVERE, "Failed to remove local spy after failed permission check", e);
                        }
                        continue;
                    }
                    PlayerCache.SpyColor color = spies.get(spy);
                    this.implementor.getMessageManager().sendFormattedLocalSpyMessage(spy, color, this.sender, (Channel)channel.get(), this.message);
                }
            }
            if (((Channel)channel.get()).logMessages) {
                String logFormat = Settings.channelLogFormat;
                logFormat = logFormat.replaceAll("%channel%", ((Channel)channel.get()).id.toUpperCase());
                logFormat = logFormat.replaceAll("%sender%", this.sender.getName());
                this.implementor.getLoggingAdapter().log(Level.INFO, logFormat + this.message);
            }
            if (Settings.doDiscordIntegration) {
                this.implementor.getWebhookDispatcher().ifPresent(dispatcher -> dispatcher.dispatchWebhook(this));
            }
        });
    }

    public static boolean passesFilters(HuskChat implementor, Player sender, StringBuilder message, Channel channel) {
        if (channel.filter && !sender.hasPermission("huskchat.bypass_filters")) {
            for (ChatFilter filter : Settings.chatFilters.get(channel.id)) {
                if (sender.hasPermission(filter.getFilterIgnorePermission())) continue;
                if (!filter.isAllowed(sender, message.toString())) {
                    implementor.getMessageManager().sendMessage(sender, filter.getFailureErrorMessageId());
                    return false;
                }
                ChatFilter chatFilter = filter;
                if (!(chatFilter instanceof ReplacerFilter)) continue;
                ReplacerFilter replacer = (ReplacerFilter)chatFilter;
                if (channel.broadcastScope.isPassThrough) continue;
                String msg = message.toString();
                message.delete(0, message.length());
                message.append(replacer.replace(msg));
            }
        }
        return true;
    }
}

