/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import dev.dejvokep.boostedyaml.YamlDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public abstract class MessageManager {
    private static final Map<String, String> messages = new HashMap<String, String>();

    public MessageManager(YamlDocument messagesConfig) {
        this.load(messagesConfig);
    }

    private void load(YamlDocument messagesConfig) {
        messages.clear();
        for (String messageId : messagesConfig.getRoutesAsStrings(false)) {
            messages.put(messageId, messagesConfig.getString(messageId, ""));
        }
    }

    public String getRawMessage(String messageID) {
        return messages.get(messageID);
    }

    public String getRawMessage(String messageID, String ... placeholderReplacements) {
        String message = messages.get(messageID);
        int replacementIndexer = 1;
        for (String replacement : placeholderReplacements) {
            String replacementString = "%" + replacementIndexer + "%";
            message = message.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        return message;
    }

    public String extractMineDownLinks(String string) {
        String[] in = string.split("\n");
        StringBuilder out = new StringBuilder();
        String regex = "[^\\[\\]\\(\\) ]*\\[([^\\(\\)]+)\\]\\([^\\(\\)]+open_url=(\\S+).*\\)";
        for (int i = 0; i < in.length; ++i) {
            Pattern pattern = Pattern.compile(regex);
            Matcher m = pattern.matcher(in[i]);
            if (m.find()) {
                out.append(in[i].replace(m.group(0), ""));
                out.append(m.group(2));
            } else {
                out.append(in[i]);
            }
            if (i + 1 == in.length) continue;
            out.append("\n");
        }
        return out.toString();
    }

    public abstract void sendMessage(Player var1, String var2, String ... var3);

    public abstract void sendMessage(Player var1, String var2);

    public abstract void sendCustomMessage(Player var1, String var2);

    public abstract void sendFormattedChannelMessage(Player var1, Player var2, Channel var3, String var4);

    public abstract void sendFormattedOutboundPrivateMessage(Player var1, ArrayList<Player> var2, String var3);

    public abstract void sendFormattedInboundPrivateMessage(ArrayList<Player> var1, Player var2, String var3);

    public abstract void sendFormattedLocalSpyMessage(Player var1, PlayerCache.SpyColor var2, Player var3, Channel var4, String var5);

    public abstract void sendFormattedSocialSpyMessage(Player var1, PlayerCache.SpyColor var2, Player var3, ArrayList<Player> var4, String var5);

    public abstract void sendFormattedBroadcastMessage(Player var1, String var2);

    public final String getGroupMemberList(ArrayList<Player> players, String delimiter) {
        StringJoiner memberList = new StringJoiner(delimiter);
        for (Player player : players) {
            memberList.add(player.getName());
        }
        return memberList.toString();
    }

    public final String convertToUnicodeSubScript(int number) {
        String numberString = Integer.toString(number);
        StringBuilder subScriptNumber = new StringBuilder();
        String[] stringArray = numberString.split("");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String digit;
            subScriptNumber.append(switch (digit = stringArray[i]) {
                case "0" -> "\u2080";
                case "1" -> "\u2081";
                case "2" -> "\u2082";
                case "3" -> "\u2083";
                case "4" -> "\u2084";
                case "5" -> "\u2085";
                case "6" -> "\u2086";
                case "7" -> "\u2087";
                case "8" -> "\u2088";
                case "9" -> "\u2089";
                default -> "";
            });
        }
        return subScriptNumber.toString();
    }
}

