/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.LocalSpyCommand;
import net.william278.huskchat.command.MsgCommand;
import net.william278.huskchat.command.OptOutMsgCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.WebhookDispatcher;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.bstats.velocity.Metrics;
import net.william278.huskchat.message.MessageManager;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.velocity.command.VelocityCommand;
import net.william278.huskchat.velocity.event.VelocityEventDispatcher;
import net.william278.huskchat.velocity.listener.VelocityListener;
import net.william278.huskchat.velocity.message.VelocityMessageManager;
import net.william278.huskchat.velocity.player.VelocityPlayer;
import net.william278.huskchat.velocity.util.VelocityLogger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Plugin(id="huskchat")
public class HuskChatVelocity
implements HuskChat {
    public static String VERSION = null;
    public static String DESCRIPTION = null;
    private static final int METRICS_ID = 14187;
    private final Metrics.Factory metricsFactory;
    private static HuskChatVelocity instance;
    public static VelocityMessageManager messageManager;
    public static DataGetter playerDataGetter;
    private final Logger logger;
    private final ProxyServer server;
    private final Path dataDirectory;
    private final VelocityEventDispatcher eventDispatcher;
    private static WebhookDispatcher webhookDispatcher;

    public static HuskChatVelocity getInstance() {
        return instance;
    }

    public File getDataFolder() {
        return this.dataDirectory.toFile();
    }

    public ProxyServer getProxyServer() {
        return this.server;
    }

    @Inject
    public HuskChatVelocity(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory, PluginContainer pluginContainer) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
        this.eventDispatcher = new VelocityEventDispatcher(server);
        pluginContainer.getDescription().getVersion().ifPresent(versionString -> {
            VERSION = versionString;
        });
        pluginContainer.getDescription().getDescription().ifPresent(descriptionString -> {
            DESCRIPTION = descriptionString;
        });
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        this.reloadSettings();
        this.reloadMessages();
        PlayerCache.setDataFolder(this.getDataFolder());
        try {
            PlayerCache.loadSpy();
        }
        catch (IOException e) {
            this.getLoggingAdapter().log(Level.SEVERE, "Failed to load spies file");
        }
        Optional luckPerms = this.getProxyServer().getPluginManager().getPlugin("luckperms");
        playerDataGetter = luckPerms.isPresent() ? new LuckPermsDataGetter() : new DefaultDataGetter();
        this.getProxyServer().getEventManager().register((Object)this, (Object)new VelocityListener());
        new VelocityCommand(new HuskChatCommand(this));
        new VelocityCommand(new ChannelCommand(this));
        if (Settings.doMessageCommand) {
            new VelocityCommand(new MsgCommand(this));
            new VelocityCommand(new ReplyCommand(this));
            new VelocityCommand(new OptOutMsgCommand(this));
        }
        if (Settings.doBroadcastCommand) {
            new VelocityCommand(new BroadcastCommand(this));
        }
        if (Settings.doSocialSpyCommand) {
            new VelocityCommand(new SocialSpyCommand(this));
        }
        if (Settings.doLocalSpyCommand) {
            new VelocityCommand(new LocalSpyCommand(this));
        }
        Settings.channels.forEach((id, channel) -> {
            for (String command : channel.shortcutCommands) {
                new VelocityCommand(new ShortcutCommand(command, channel.id, this));
            }
        });
        if (Settings.doDiscordIntegration) {
            webhookDispatcher = new WebhookDispatcher(Settings.webhookUrls);
        }
        this.metricsFactory.make(this, 14187);
        this.getLoggingAdapter().info("Enabled HuskChat version " + this.getMetaVersion());
    }

    @Override
    @NotNull
    public MessageManager getMessageManager() {
        return messageManager;
    }

    @Override
    @NotNull
    public VelocityEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public Optional<WebhookDispatcher> getWebhookDispatcher() {
        if (webhookDispatcher != null) {
            return Optional.of(webhookDispatcher);
        }
        return Optional.empty();
    }

    @Override
    public void reloadSettings() {
        try {
            Settings.load(YamlDocument.create(new File(this.getDataFolder(), "config.yml"), Objects.requireNonNull(HuskChat.class.getClassLoader().getResourceAsStream("config.yml")), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.builder().setEncoding(DumperSettings.Encoding.UNICODE).build(), UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build()));
        }
        catch (IOException e) {
            this.getLoggingAdapter().log(Level.SEVERE, "Failed to load config file");
        }
    }

    @Override
    public void reloadMessages() {
        try {
            messageManager = new VelocityMessageManager();
        }
        catch (IOException e) {
            this.getLoggingAdapter().log(Level.SEVERE, "Failed to load messages file");
        }
    }

    @Override
    @NotNull
    public String getMetaVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public String getMetaDescription() {
        return DESCRIPTION;
    }

    @Override
    @NotNull
    public String getMetaPlatform() {
        return "Velocity";
    }

    @Override
    public DataGetter getDataGetter() {
        return playerDataGetter;
    }

    @Override
    public Optional<net.william278.huskchat.player.Player> getPlayer(UUID uuid) {
        Optional player = this.getProxyServer().getPlayer(uuid);
        return player.map(VelocityPlayer::adaptCrossPlatform);
    }

    @Override
    public Collection<net.william278.huskchat.player.Player> getOnlinePlayers() {
        ArrayList<net.william278.huskchat.player.Player> velocityPlayers = new ArrayList<net.william278.huskchat.player.Player>();
        for (Player player : this.getProxyServer().getAllPlayers()) {
            velocityPlayers.add(VelocityPlayer.adaptCrossPlatform(player));
        }
        return velocityPlayers;
    }

    @Override
    public Collection<net.william278.huskchat.player.Player> getOnlinePlayersOnServer(net.william278.huskchat.player.Player serverPlayer) {
        ArrayList<net.william278.huskchat.player.Player> velocityPlayers = new ArrayList<net.william278.huskchat.player.Player>();
        VelocityPlayer.adaptVelocity(serverPlayer).flatMap(Player::getCurrentServer).ifPresent(serverConnection -> {
            for (Player connectedPlayer : serverConnection.getServer().getPlayersConnected()) {
                velocityPlayers.add(VelocityPlayer.adaptCrossPlatform(connectedPlayer));
            }
        });
        return velocityPlayers;
    }

    @Override
    @NotNull
    public net.william278.huskchat.util.Logger getLoggingAdapter() {
        return VelocityLogger.get(this.logger);
    }

    @Override
    public Optional<net.william278.huskchat.player.Player> matchPlayer(String username) {
        Optional<net.william278.huskchat.player.Player> optionalPlayer;
        if (username.isEmpty()) {
            return Optional.empty();
        }
        if (this.getProxyServer().getPlayer(username).isPresent()) {
            Player player = (Player)this.getProxyServer().getPlayer(username).get();
            optionalPlayer = Optional.of(VelocityPlayer.adaptCrossPlatform(player));
        } else {
            List<Player> matchedPlayers = this.getProxyServer().matchPlayer(username).stream().filter(val -> val.getUsername().startsWith(username)).sorted().toList();
            optionalPlayer = matchedPlayers.size() > 0 ? Optional.of(VelocityPlayer.adaptCrossPlatform(matchedPlayers.get(0))) : Optional.empty();
        }
        return optionalPlayer;
    }
}

