/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.message.PrivateMessage;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class ReplyCommand
extends CommandBase {
    private static final String PERMISSION = "huskchat.command.msg.reply";

    public ReplyCommand(HuskChat implementor) {
        super(Settings.replyCommandAliases.get(0), PERMISSION, implementor, Settings.getAliases(Settings.replyCommandAliases));
    }

    @Override
    public void onExecute(Player player, String[] args) {
        if (player.hasPermission(this.permission)) {
            if (args.length >= 1) {
                Optional<HashSet<UUID>> lastMessengers = PlayerCache.getLastMessengers(player.getUuid());
                if (lastMessengers.isEmpty()) {
                    this.implementor.getMessageManager().sendMessage(player, "error_reply_no_messages");
                    return;
                }
                ArrayList<String> lastPlayers = new ArrayList<String>();
                for (UUID uUID : lastMessengers.get()) {
                    if (ConsolePlayer.isConsolePlayer(uUID)) {
                        lastPlayers.add(ConsolePlayer.adaptConsolePlayer(this.implementor).getName());
                        continue;
                    }
                    this.implementor.getPlayer(uUID).ifPresent(onlineMessenger -> lastPlayers.add(onlineMessenger.getName()));
                }
                if (lastPlayers.isEmpty()) {
                    if (lastMessengers.get().size() > 1) {
                        this.implementor.getMessageManager().sendMessage(player, "error_reply_none_online");
                    } else {
                        this.implementor.getMessageManager().sendMessage(player, "error_reply_not_online");
                    }
                    return;
                }
                StringJoiner message = new StringJoiner(" ");
                for (String arg : args) {
                    message.add(arg);
                }
                String string = message.toString();
                new PrivateMessage(player, lastPlayers, string, this.implementor).dispatch();
            } else {
                this.implementor.getMessageManager().sendMessage(player, "error_invalid_syntax", "/r <message>");
            }
        } else {
            this.implementor.getMessageManager().sendMessage(player, "error_no_permission");
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] args) {
        return Collections.emptyList();
    }
}

