/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.player.Player;

public class SpamFilter
extends ChatFilter {
    private final HashMap<UUID, LinkedList<Long>> userMessageQueues;
    private final int periodLength;
    private final int maxMessagesPerPeriod;

    public SpamFilter(int periodLength, int maxMessagesPerPeriod) {
        this.periodLength = periodLength;
        this.maxMessagesPerPeriod = maxMessagesPerPeriod;
        this.userMessageQueues = new HashMap();
    }

    @Override
    public boolean isAllowed(Player player, String message) {
        if (!this.userMessageQueues.containsKey(player.getUuid())) {
            this.userMessageQueues.put(player.getUuid(), new LinkedList());
        }
        long currentTimestamp = Instant.now().getEpochSecond();
        if (!this.userMessageQueues.get(player.getUuid()).isEmpty()) {
            if (currentTimestamp > this.userMessageQueues.get(player.getUuid()).getLast() + (long)this.periodLength) {
                this.userMessageQueues.get(player.getUuid()).removeLast();
            }
            if (this.userMessageQueues.get(player.getUuid()).size() > this.maxMessagesPerPeriod) {
                return false;
            }
        }
        this.userMessageQueues.get(player.getUuid()).addFirst(currentTimestamp);
        return true;
    }

    @Override
    public String getFailureErrorMessageId() {
        return "error_chat_filter_spam";
    }

    @Override
    public String getFilterIgnorePermission() {
        return "huskchat.ignore_filters.spam";
    }
}

