/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.filter.replacer.ReplacerFilter;
import net.william278.huskchat.player.Player;

public class BroadcastMessage {
    private Player sender;
    private String message;
    private HuskChat implementor;

    public BroadcastMessage(Player sender, String message, HuskChat implementor) {
        this.sender = sender;
        this.message = message;
        this.implementor = implementor;
    }

    public void dispatch() {
        this.implementor.getEventDispatcher().dispatchBroadcastMessageEvent(this.sender, this.message).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.message = event.getMessage();
            if (!this.sender.hasPermission("huskchat.bypass_filters")) {
                for (ChatFilter filter : Settings.chatFilters.get("broadcast_messages")) {
                    if (this.sender.hasPermission(filter.getFilterIgnorePermission())) continue;
                    if (!filter.isAllowed(this.sender, this.message)) {
                        this.implementor.getMessageManager().sendMessage(this.sender, filter.getFailureErrorMessageId());
                        return;
                    }
                    ChatFilter replacer$temp = filter;
                    if (!(replacer$temp instanceof ReplacerFilter)) continue;
                    ReplacerFilter replacer = (ReplacerFilter)replacer$temp;
                    this.message = replacer.replace(this.message);
                }
            }
            for (Player player : this.implementor.getOnlinePlayers()) {
                this.implementor.getMessageManager().sendFormattedBroadcastMessage(player, this.message);
            }
            if (Settings.logBroadcasts) {
                this.implementor.getLoggingAdapter().log(Level.INFO, Settings.broadcastLogFormat + this.message);
            }
        });
    }
}

