/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.player.Player;

public class HuskChatCommand
extends CommandBase {
    private static final String PERMISSION = "huskchat.command.huskchat";
    private static final String[] COMMAND_TAB_ARGUMENTS = new String[]{"about", "reload"};
    private final String pluginInformation;

    public HuskChatCommand(HuskChat implementor) {
        super("huskchat", PERMISSION, implementor, "hc");
        this.pluginInformation = "[HuskChat](#00fb9a bold) [| " + implementor.getMetaPlatform() + " Version " + implementor.getMetaVersion() + "](#00fb9a)\n[" + implementor.getMetaDescription() + "](gray)\n[\u2022 Author:](white) [William278](gray show_text=&7Click to visit website open_url=https://william278.net)\n[\u2022 Contributors:](white) [TrueWinter](gray show_text=&7Code), [Ironboundred](gray show_text=&7Code)\n[\u2022 Translators:](white) [xF3d3](gray show_text=&7Italian, it-it), [MalzSmith](gray show_text=&7Hungarian, hu-hu), [Ceddix](gray show_text=&7German, de-de), [Pukejoy_1](gray show_text=&7Bulgarian, bg-bg)\n[\u2022 Help Wiki:](white) [[Link]](#00fb9a show_text=&7Click to open link open_url=https://william278.net/docs/huskchat/Home)\n[\u2022 Report Issues:](white) [[Link]](#00fb9a show_text=&7Click to open link open_url=https://github.com/WiIIiam278/HuskChat/issues)\n[\u2022 Support Discord:](white) [[Link]](#00fb9a show_text=&7Click to join open_url=https://discord.gg/tVYhJfyDWG)";
    }

    @Override
    public void onExecute(Player player, String[] args) {
        if (player.hasPermission(this.permission)) {
            if (args.length == 1) {
                switch (args[0].toLowerCase(Locale.ROOT)) {
                    case "about": 
                    case "info": {
                        this.sendAboutInformation(player);
                        break;
                    }
                    case "reload": {
                        this.implementor.reloadSettings();
                        this.implementor.reloadMessages();
                        this.implementor.getMessageManager().sendCustomMessage(player, "[HuskChat](#00fb9a bold) &#00fb9a&| Reloaded config & message files.");
                        break;
                    }
                    default: {
                        this.implementor.getMessageManager().sendMessage(player, "error_invalid_syntax", "/huskchat <about/reload>");
                        break;
                    }
                }
            } else {
                this.sendAboutInformation(player);
            }
        } else {
            this.implementor.getMessageManager().sendMessage(player, "error_no_permission");
        }
    }

    private void sendAboutInformation(Player player) {
        this.implementor.getMessageManager().sendCustomMessage(player, this.pluginInformation);
    }

    @Override
    public List<String> onTabComplete(Player player, String[] args) {
        if (!player.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        if (args.length <= 1) {
            return Arrays.stream(COMMAND_TAB_ARGUMENTS).filter(val -> val.toLowerCase().startsWith(args.length >= 1 ? args[0].toLowerCase() : "")).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

