/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class OptOutMsgCommand
extends CommandBase {
    private static final String PERMISSION = "huskchat.command.optoutmsg";

    public OptOutMsgCommand(HuskChat implementor) {
        super("optoutmsg", PERMISSION, implementor, new String[0]);
    }

    @Override
    public void onExecute(Player player, String[] args) {
        PlayerCache.getLastMessengers(player.getUuid()).ifPresentOrElse(lastMessengers -> {
            if (lastMessengers.size() <= 1) {
                this.implementor.getMessageManager().sendMessage(player, "error_last_message_not_group");
                return;
            }
            for (UUID uuid : lastMessengers) {
                PlayerCache.getLastMessengers(uuid).ifPresent(last -> last.remove(player.getUuid()));
            }
            String playerList = lastMessengers.stream().flatMap(u -> this.implementor.getPlayer((UUID)u).stream()).map(Player::getName).collect(Collectors.joining(", "));
            StringBuilder builder = new StringBuilder();
            int lastComma = playerList.lastIndexOf(44);
            builder.append(playerList, 0, lastComma);
            builder.append(" ").append(this.implementor.getMessageManager().getRawMessage("list_conjunction"));
            builder.append(playerList.substring(lastComma + 1));
            this.implementor.getMessageManager().sendMessage(player, "removed_from_group_message", builder.toString());
            lastMessengers.clear();
        }, () -> this.implementor.getMessageManager().sendMessage(player, "error_no_messages_opt_out"));
    }

    @Override
    public List<String> onTabComplete(Player player, String[] args) {
        return new ArrayList<String>();
    }
}

