/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class SocialSpyCommand
extends CommandBase {
    private static final String PERMISSION = "huskchat.command.socialspy";

    public SocialSpyCommand(HuskChat implementor) {
        super(Settings.socialSpyCommandAliases.get(0), PERMISSION, implementor, Settings.getAliases(Settings.socialSpyCommandAliases));
    }

    @Override
    public void onExecute(Player player, String[] args) {
        if (player instanceof ConsolePlayer) {
            this.implementor.getLoggingAdapter().log(Level.INFO, this.implementor.getMessageManager().getRawMessage("error_in_game_only"));
            return;
        }
        if (player.hasPermission(this.permission)) {
            Optional<PlayerCache.SpyColor> selectedColor;
            if (args.length == 1 && (selectedColor = PlayerCache.SpyColor.getColor(args[0])).isPresent()) {
                try {
                    PlayerCache.SpyColor color = selectedColor.get();
                    PlayerCache.setSocialSpy(player, color);
                    this.implementor.getMessageManager().sendMessage(player, "social_spy_toggled_on_color", color.colorCode, color.name().toLowerCase().replaceAll("_", " "));
                }
                catch (IOException e) {
                    this.implementor.getLoggingAdapter().log(Level.SEVERE, "Failed to save social spy state to spies file");
                }
                return;
            }
            if (!PlayerCache.isSocialSpying(player)) {
                try {
                    PlayerCache.setSocialSpy(player);
                    this.implementor.getMessageManager().sendMessage(player, "social_spy_toggled_on");
                }
                catch (IOException e) {
                    this.implementor.getLoggingAdapter().log(Level.SEVERE, "Failed to save social spy state to spies file");
                }
            } else {
                try {
                    PlayerCache.removeSocialSpy(player);
                    this.implementor.getMessageManager().sendMessage(player, "social_spy_toggled_off");
                }
                catch (IOException e) {
                    this.implementor.getLoggingAdapter().log(Level.SEVERE, "Failed to save social spy state to spies file");
                }
            }
        } else {
            this.implementor.getMessageManager().sendMessage(player, "error_no_permission");
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] args) {
        return Collections.emptyList();
    }
}

