/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.boostedyaml.YamlDocument;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.libraries.minedown.adventure.MineDownParser;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.util.PlaceholderReplacer;

public class MessageManager {
    @NotNull
    private final HuskChat plugin;
    @NotNull
    private final Map<String, String> messages = new HashMap<String, String>();

    public MessageManager(@NotNull HuskChat plugin) {
        this.plugin = plugin;
        String languagePath = "languages/" + Settings.language + ".yml";
        try (InputStream stream = Objects.requireNonNull(plugin.getResourceAsStream(languagePath));){
            YamlDocument document = YamlDocument.create(new File(plugin.getDataFolder(), "messages-" + Settings.language + ".yml"), stream);
            this.load(document);
        }
        catch (IOException | NullPointerException e) {
            plugin.getLoggingAdapter().log(Level.SEVERE, "Failed to load messages file", e);
        }
    }

    private void load(YamlDocument document) {
        this.messages.clear();
        for (String messageId : document.getRoutesAsStrings(false)) {
            this.messages.put(messageId, document.getString(messageId, ""));
        }
    }

    public String getRawMessage(@NotNull String messageID) {
        return this.messages.get(messageID);
    }

    public String extractMineDownLinks(String string) {
        String[] in = string.split("\n");
        StringBuilder out = new StringBuilder();
        String regex = "[^\\[\\]() ]*\\[([^()]+)]\\([^()]+open_url=(\\S+).*\\)";
        for (int i = 0; i < in.length; ++i) {
            Pattern pattern = Pattern.compile(regex);
            Matcher m = pattern.matcher(in[i]);
            if (m.find()) {
                out.append(in[i].replace(m.group(0), ""));
                out.append(m.group(2));
            } else {
                out.append(in[i]);
            }
            if (i + 1 == in.length) continue;
            out.append("\n");
        }
        return out.toString();
    }

    public void sendMessage(@NotNull Player player, String messageId, String ... placeholderReplacements) {
        String message = this.getRawMessage(messageId);
        if (message == null || message.isEmpty()) {
            return;
        }
        int replacementIndexer = 1;
        for (String replacement : placeholderReplacements) {
            String replacementString = "%" + replacementIndexer + "%";
            message = message.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        player.sendMessage(new MineDown(message));
    }

    public void sendMessage(Player player, String messageId) {
        this.sendMessage(player, messageId, new String[0]);
    }

    public void sendCustomMessage(Player player, String message) {
        if (player instanceof ConsolePlayer) {
            this.sendMineDownToConsole(message);
            return;
        }
        player.sendMessage(new MineDown(message));
    }

    public void sendFormattedChannelMessage(Player target, Player sender, Channel channel, String message) {
        TextComponent.Builder componentBuilder = (TextComponent.Builder)Component.text().append(new MineDown(PlaceholderReplacer.replace(sender, channel.format, this.plugin)).toComponent());
        if (sender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append((Component)Component.text(message));
        }
        target.sendMessage((Component)componentBuilder.build());
    }

    public void sendFormattedOutboundPrivateMessage(Player messageSender, ArrayList<Player> messageRecipients, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        if (messageRecipients.size() == 1) {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageRecipients.get(0), Settings.outboundMessageFormat, this.plugin)).toComponent());
        } else {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageRecipients.get(0), Settings.groupOutboundMessageFormat, this.plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(messageRecipients.size() - 1)).replace("%group_amount%", Integer.toString(messageRecipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(messageRecipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(messageRecipients, "\n")))).toComponent());
        }
        if (messageSender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append((Component)Component.text(message));
        }
        if (messageSender instanceof ConsolePlayer) {
            this.plugin.getConsoleAudience().sendMessage((Component)componentBuilder.build());
            return;
        }
        messageSender.sendMessage((Component)componentBuilder.build());
    }

    public void sendFormattedInboundPrivateMessage(ArrayList<Player> messageRecipients, Player messageSender, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        if (messageRecipients.size() == 1) {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageSender, Settings.inboundMessageFormat, this.plugin)).toComponent());
        } else {
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(messageSender, Settings.groupInboundMessageFormat, this.plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(messageRecipients.size() - 1)).replace("%group_amount%", Integer.toString(messageRecipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(messageRecipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(messageRecipients, "\n")))).toComponent());
        }
        if (messageSender.hasPermission("huskchat.formatted_chat")) {
            componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        } else {
            componentBuilder.append((Component)Component.text(message));
        }
        for (Player recipient : messageRecipients) {
            if (recipient instanceof ConsolePlayer) {
                this.plugin.getConsoleAudience().sendMessage((Component)componentBuilder.build());
                return;
            }
            recipient.sendMessage((Component)componentBuilder.build());
        }
    }

    public void sendFormattedLocalSpyMessage(Player spy, PlayerCache.SpyColor spyColor, Player sender, Channel channel, String message) {
        TextComponent.Builder componentBuilder = (TextComponent.Builder)Component.text().append(new MineDown(PlaceholderReplacer.replace(sender, Settings.localSpyFormat, this.plugin).replace("%spy_color%", spyColor.colorCode).replace("%channel%", channel.id) + MineDown.escape(message)).toComponent());
        spy.sendMessage((Component)componentBuilder.build());
    }

    public void sendFormattedSocialSpyMessage(Player spy, PlayerCache.SpyColor spyColor, Player sender, ArrayList<Player> receivers, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        if (receivers.size() == 1) {
            Player receiver = receivers.get(0);
            componentBuilder.append(new MineDown(PlaceholderReplacer.replace(receiver, PlaceholderReplacer.replace(sender, Settings.socialSpyFormat.replace("%sender_", "%"), this.plugin).replace("%receiver_", "%"), this.plugin).replace("%spy_color%", spyColor.colorCode) + MineDown.escape(message)).toComponent());
        } else {
            Player firstReceiver = receivers.get(0);
            String md = PlaceholderReplacer.replace(firstReceiver, PlaceholderReplacer.replace(sender, Settings.socialSpyGroupFormat.replace("%sender_", "%"), this.plugin).replace("%receiver_", "%"), this.plugin).replace("%group_amount_subscript%", this.convertToUnicodeSubScript(receivers.size() - 1)).replace("%group_amount%", Integer.toString(receivers.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(receivers, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(receivers, "\n"))).replace("%spy_color%", spyColor.colorCode) + MineDown.escape(message);
            componentBuilder.append(new MineDown(md).toComponent());
        }
        spy.sendMessage((Component)componentBuilder.build());
    }

    public void sendFormattedBroadcastMessage(Player player, String message) {
        TextComponent.Builder componentBuilder = Component.text();
        componentBuilder.append(new MineDown(Settings.broadcastMessageFormat).toComponent());
        componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        player.sendMessage((Component)componentBuilder.build());
    }

    private void sendMineDownToConsole(@NotNull String mineDown) {
        this.plugin.getConsoleAudience().sendMessage(Component.text(this.extractMineDownLinks(mineDown)));
    }

    public final String getGroupMemberList(ArrayList<Player> players, String delimiter) {
        StringJoiner memberList = new StringJoiner(delimiter);
        for (Player player : players) {
            memberList.add(player.getName());
        }
        return memberList.toString();
    }

    public final String convertToUnicodeSubScript(int number) {
        String numberString = Integer.toString(number);
        StringBuilder subScriptNumber = new StringBuilder();
        String[] stringArray = numberString.split("");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String digit;
            subScriptNumber.append(switch (digit = stringArray[i]) {
                case "0" -> "\u2080";
                case "1" -> "\u2081";
                case "2" -> "\u2082";
                case "3" -> "\u2083";
                case "4" -> "\u2084";
                case "5" -> "\u2085";
                case "6" -> "\u2086";
                case "7" -> "\u2087";
                case "8" -> "\u2088";
                case "9" -> "\u2089";
                default -> "";
            });
        }
        return subScriptNumber.toString();
    }
}

