/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.player;

import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public class ConsolePlayer
implements Player {
    private static final UUID consoleUUID = new UUID(0L, 0L);
    private static final String consoleUsername = "[CONSOLE]";
    private HuskChat implementor;

    private ConsolePlayer() {
    }

    @Override
    public String getName() {
        return consoleUsername;
    }

    @Override
    public UUID getUuid() {
        return consoleUUID;
    }

    @Override
    public int getPing() {
        return 0;
    }

    @Override
    public String getServerName() {
        return this.implementor.getMetaPlatform();
    }

    @Override
    public int getPlayersOnServer() {
        return this.implementor.getOnlinePlayers().size();
    }

    @Override
    public boolean hasPermission(String node) {
        return true;
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.implementor.getConsoleAudience();
    }

    public static ConsolePlayer adaptConsolePlayer(HuskChat plugin) {
        ConsolePlayer consolePlayer = new ConsolePlayer();
        consolePlayer.implementor = plugin;
        return consolePlayer;
    }

    public static boolean isConsolePlayer(UUID uuid) {
        return uuid.equals(consoleUUID);
    }

    public static boolean isConsolePlayer(String username) {
        return username.equals(consoleUsername);
    }
}

