/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.discord.DiscordMessageFormat;
import net.william278.huskchat.filter.AdvertisingFilterer;
import net.william278.huskchat.filter.AsciiFilter;
import net.william278.huskchat.filter.CapsFilter;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.filter.ProfanityFilterer;
import net.william278.huskchat.filter.RepeatFilter;
import net.william278.huskchat.filter.SpamFilter;
import net.william278.huskchat.filter.replacer.EmojiReplacer;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.boostedyaml.YamlDocument;
import net.william278.huskchat.libraries.boostedyaml.block.implementation.Section;

public class Settings {
    public static String language;
    public static String defaultChannel;
    public static HashMap<String, String> serverDefaultChannels;
    public static HashMap<String, Channel> channels;
    public static String channelLogFormat;
    public static List<String> channelCommandAliases;
    public static boolean doMessageCommand;
    public static boolean doGroupMessages;
    public static int maxGroupMessageSize;
    public static List<String> messageCommandAliases;
    public static List<String> replyCommandAliases;
    public static String inboundMessageFormat;
    public static String outboundMessageFormat;
    public static String groupInboundMessageFormat;
    public static String groupOutboundMessageFormat;
    public static boolean logPrivateMessages;
    public static boolean censorPrivateMessages;
    public static String messageLogFormat;
    public static List<String> messageCommandRestrictedServers;
    public static boolean doSocialSpyCommand;
    public static String socialSpyFormat;
    public static String socialSpyGroupFormat;
    public static List<String> socialSpyCommandAliases;
    public static boolean doLocalSpyCommand;
    public static String localSpyFormat;
    public static List<String> excludedLocalSpyChannels;
    public static List<String> localSpyCommandAliases;
    public static boolean doBroadcastCommand;
    public static List<String> broadcastCommandAliases;
    public static String broadcastMessageFormat;
    public static boolean logBroadcasts;
    public static String broadcastLogFormat;
    public static Map<String, List<ChatFilter>> chatFilters;
    public static boolean doDiscordIntegration;
    public static Map<String, URL> webhookUrls;
    public static DiscordMessageFormat webhookMessageFormat;
    public static Map<String, String> serverNameReplacement;

    private Settings() {
    }

    public static void load(YamlDocument configFile) {
        language = configFile.getString("language", "en-gb");
        defaultChannel = configFile.getString("default_channel", "global");
        channelLogFormat = configFile.getString("channel_log_format", "[CHAT] [%channel%] %sender%: ");
        channels.putAll(Settings.fetchChannels(configFile));
        serverDefaultChannels = Settings.getServerDefaultChannels(configFile);
        channelCommandAliases = configFile.contains("channel_command_aliases") ? Settings.getCommandsFromList(configFile.getStringList("channel_command_aliases")) : Collections.singletonList("channel");
        doMessageCommand = configFile.getBoolean("message_command.enabled", (Boolean)true);
        doGroupMessages = configFile.getBoolean("message_command.group_messages.enabled", (Boolean)true);
        maxGroupMessageSize = configFile.getInt("message_command.group_messages.max_size", (Integer)5);
        inboundMessageFormat = configFile.getString("message_command.format.inbound", "&#00fb9a&%name% &8\u2192 &#00fb9a&You&8: &f");
        outboundMessageFormat = configFile.getString("message_command.format.outbound", "&#00fb9a&You &8\u2192 &#00fb9a&%name%&8 &f");
        groupInboundMessageFormat = configFile.getString("message_command.format.group_inbound", "&#00fb9a&%name% &8\u2192 &#00fb9a&You[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%)&8: &f");
        groupOutboundMessageFormat = configFile.getString("message_command.format.group_outbound", "&#00fb9a&You &8\u2192 &#00fb9a&%name%[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%)&8: &f");
        logPrivateMessages = configFile.getBoolean("message_command.log_to_console", (Boolean)true);
        censorPrivateMessages = configFile.getBoolean("message_command.censor", (Boolean)false);
        messageLogFormat = configFile.getString("message_command.log_format", "[MSG] [%sender% -> %receiver%]: ");
        messageCommandRestrictedServers = configFile.getStringList("message_command.restricted_servers");
        messageCommandAliases = configFile.contains("message_command.msg_aliases") ? Settings.getCommandsFromList(configFile.getStringList("message_command.msg_aliases")) : Collections.singletonList("msg");
        replyCommandAliases = configFile.contains("message_command.reply_aliases") ? Settings.getCommandsFromList(configFile.getStringList("message_command.reply_aliases")) : Collections.singletonList("reply");
        doSocialSpyCommand = configFile.getBoolean("social_spy.enabled", (Boolean)true);
        socialSpyFormat = configFile.getString("social_spy.format", "&e[Spy] &7%sender% &8\u2192 &7%receiver%:%spy_color% ");
        socialSpyGroupFormat = configFile.getString("social_spy.group_format", "&e[Spy] &7%sender_name% &8\u2192 &7%receiver_name%[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%):%spy_color% ");
        socialSpyCommandAliases = configFile.contains("social_spy.socialspy_aliases") ? Settings.getCommandsFromList(configFile.getStringList("social_spy.socialspy_aliases")) : Collections.singletonList("socialspy");
        doLocalSpyCommand = configFile.getBoolean("local_spy.enabled", (Boolean)true);
        localSpyFormat = configFile.getString("local_spy.format", "&e[Spy] &7[%channel%] %name%&8:%spy_color% ");
        excludedLocalSpyChannels = configFile.contains("local_spy.excluded_local_channels") ? configFile.getStringList("local_spy.excluded_local_channels") : new ArrayList();
        localSpyCommandAliases = configFile.contains("local_spy.localspy_aliases") ? Settings.getCommandsFromList(configFile.getStringList("local_spy.localspy_aliases")) : Collections.singletonList("localspy");
        doBroadcastCommand = configFile.getBoolean("broadcast_command.enabled", (Boolean)true);
        broadcastCommandAliases = configFile.contains("broadcast_command.broadcast_aliases") ? Settings.getCommandsFromList(configFile.getStringList("broadcast_command.broadcast_aliases")) : Collections.singletonList("broadcast");
        broadcastMessageFormat = configFile.getString("broadcast_command.format", "&6[Broadcast]&e ");
        logBroadcasts = configFile.getBoolean("broadcast_command.log_to_console", (Boolean)true);
        broadcastLogFormat = configFile.getString("broadcast_command.log_format", "[BROADCAST]: ");
        chatFilters = Settings.fetchChatFilters(configFile);
        doDiscordIntegration = configFile.getBoolean("discord.enabled", (Boolean)false);
        webhookMessageFormat = DiscordMessageFormat.getMessageFormat(configFile.getString("discord.format_style", "inline")).orElse(DiscordMessageFormat.INLINE);
        webhookUrls = Settings.fetchWebhookUrls(configFile);
        Section serverNameReplacementSection = configFile.getSection("server_name_replacement");
        if (serverNameReplacementSection != null) {
            for (String s : serverNameReplacementSection.getRoutesAsStrings(false)) {
                serverNameReplacement.put(s, serverNameReplacementSection.getString(s));
            }
        }
    }

    private static HashMap<String, Channel> fetchChannels(YamlDocument configFile) throws IllegalArgumentException {
        HashMap<String, Channel> channels = new HashMap<String, Channel>();
        for (String channelID : configFile.getSection("channels").getRoutesAsStrings(false)) {
            String format = configFile.getString("channels." + channelID + ".format", "%fullname%&r: ");
            String broadcastScope = configFile.getString("channels." + channelID + ".broadcast_scope", "GLOBAL").toUpperCase();
            Channel channel = new Channel(channelID.toLowerCase(), format, Channel.BroadcastScope.valueOf(broadcastScope));
            if (configFile.contains("channels." + channelID + ".shortcut_commands")) {
                channel.shortcutCommands = Settings.getCommandsFromList(configFile.getStringList("channels." + channelID + ".shortcut_commands"));
            }
            if (configFile.contains("channels." + channelID + ".restricted_servers")) {
                channel.restrictedServers = configFile.getStringList("channels." + channelID + ".restricted_servers");
            }
            channel.sendPermission = configFile.getString("channels." + channelID + ".permissions.send", null);
            channel.receivePermission = configFile.getString("channels." + channelID + ".permissions.receive", null);
            channel.logMessages = configFile.getBoolean("channels." + channelID + ".log_to_console", (Boolean)true);
            channel.filter = configFile.getBoolean("channels." + channelID + ".filtered", (Boolean)true);
            channels.put(channelID, channel);
        }
        return channels;
    }

    private static Map<String, List<ChatFilter>> fetchChatFilters(YamlDocument configFile) {
        List<String> channels;
        HashMap<String, List<ChatFilter>> filters = new HashMap<String, List<ChatFilter>>();
        Settings.clearChatFilters();
        for (String string : configFile.getSection("channels").getRoutesAsStrings(false)) {
            filters.put(string, new ArrayList());
        }
        filters.put("private_messages", new ArrayList());
        filters.put("broadcast_messages", new ArrayList());
        if (configFile.getBoolean("chat_filters.advertising_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.advertising_filter.channels");
            if (configFile.getBoolean("chat_filters.advertising_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.advertising_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new AdvertisingFilterer());
            }
        }
        if (configFile.getBoolean("chat_filters.caps_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.caps_filter.channels");
            if (configFile.getBoolean("chat_filters.caps_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.caps_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new CapsFilter(configFile.getDouble("chat_filters.caps_filter.max_caps_percentage", (Double)0.4)));
            }
        }
        if (configFile.getBoolean("chat_filters.spam_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.spam_filter.channels");
            if (configFile.getBoolean("chat_filters.spam_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.spam_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new SpamFilter(configFile.getInt("chat_filters.spam_filter.period_seconds", (Integer)4), configFile.getInt("chat_filters.spam_filter.messages_per_period", (Integer)3)));
            }
        }
        if (configFile.getBoolean("chat_filters.repeat_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.repeat_filter.channels");
            if (configFile.getBoolean("chat_filters.repeat_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.repeat_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new RepeatFilter(configFile.getInt("chat_filters.repeat_filter.previous_messages_to_check", (Integer)2)));
            }
        }
        if (configFile.getBoolean("chat_filters.profanity_filter.enabled", (Boolean)false).booleanValue()) {
            channels = configFile.getStringList("chat_filters.profanity_filter.channels");
            if (configFile.getBoolean("chat_filters.profanity_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.profanity_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new ProfanityFilterer(ProfanityFilterer.ProfanityFilterMode.valueOf(configFile.getString("chat_filters.profanity_filter.mode", "TOLERANCE").toUpperCase()), configFile.getDouble("chat_filters.profanity_filter.tolerance", (Double)0.78), configFile.getString("chat_filters.profanity_filter.library_path", "")));
            }
        }
        if (configFile.getBoolean("chat_filters.ascii_filter.enabled", (Boolean)false).booleanValue()) {
            channels = configFile.getStringList("chat_filters.ascii_filter.channels");
            if (configFile.getBoolean("chat_filters.ascii_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.ascii_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new AsciiFilter());
            }
        }
        if (configFile.getBoolean("message_replacers.emoji_replacer.enabled", (Boolean)true).booleanValue()) {
            HashMap<String, String> emojiSequences = new HashMap<String, String>();
            boolean bl = configFile.getBoolean("message_replacers.emoji_replacer.case_insensitive", (Boolean)false);
            for (String characters : configFile.getSection("message_replacers.emoji_replacer.emoji").getRoutesAsStrings(false)) {
                if (!bl) {
                    emojiSequences.put(characters, configFile.getString("message_replacers.emoji_replacer.emoji." + characters));
                    continue;
                }
                emojiSequences.put(characters.toLowerCase(Locale.ROOT), configFile.getString("message_replacers.emoji_replacer.emoji." + characters));
            }
            List<String> list = configFile.getStringList("message_replacers.emoji_replacer.channels");
            if (configFile.getBoolean("chat_filters.emoji_replacer.private_messages", (Boolean)true).booleanValue()) {
                list.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.emoji_replacer.broadcast_messages", (Boolean)true).booleanValue()) {
                list.add("broadcast_messages");
            }
            for (String channel : list) {
                if (!filters.containsKey(channel)) continue;
                ((List)filters.get(channel)).add(new EmojiReplacer(emojiSequences, bl));
            }
        }
        return filters;
    }

    private static HashMap<String, URL> fetchWebhookUrls(@NotNull YamlDocument configFile) {
        HashMap<String, URL> webhookUrls = new HashMap<String, URL>();
        try {
            if (configFile.contains("discord.channel_webhooks")) {
                for (String channelID : configFile.getSection("discord.channel_webhooks").getRoutesAsStrings(false)) {
                    if (!channels.containsKey(channelID)) continue;
                    webhookUrls.put(channelID, new URL(configFile.getString("discord.channel_webhooks." + channelID)));
                }
            }
        }
        catch (MalformedURLException e) {
            doDiscordIntegration = false;
        }
        return webhookUrls;
    }

    private static HashMap<String, String> getServerDefaultChannels(YamlDocument configFile) {
        HashMap<String, String> serverDefaults = new HashMap<String, String>();
        if (configFile.contains("server_default_channels")) {
            for (String server : configFile.getSection("server_default_channels").getRoutesAsStrings(false)) {
                String channelId = configFile.getString("server_default_channels." + server);
                serverDefaults.put(server, channelId);
            }
        }
        return serverDefaults;
    }

    private static List<String> getCommandsFromList(List<String> rawCommands) {
        ArrayList<String> commands = new ArrayList<String>();
        for (String command : rawCommands) {
            commands.add(command.substring(1));
        }
        return commands;
    }

    public static boolean isLocalSpyChannelExcluded(Channel channel) {
        for (String excludedChannel : excludedLocalSpyChannels) {
            if (!excludedChannel.equals(channel.id)) continue;
            return true;
        }
        return false;
    }

    private static void clearChatFilters() {
        chatFilters = new HashMap<String, List<ChatFilter>>();
    }

    public static String[] getAliases(List<String> aliases) {
        if (aliases.size() <= 1) {
            return new String[0];
        }
        String[] aliasList = new String[aliases.size() - 1];
        for (int i = 1; i < aliases.size(); ++i) {
            aliasList[i - 1] = aliases.get(i);
        }
        return aliasList;
    }

    static {
        serverDefaultChannels = new HashMap();
        channels = new HashMap();
        channelCommandAliases = new ArrayList<String>();
        messageCommandAliases = new ArrayList<String>();
        replyCommandAliases = new ArrayList<String>();
        messageCommandRestrictedServers = new ArrayList<String>();
        socialSpyCommandAliases = new ArrayList<String>();
        excludedLocalSpyChannels = new ArrayList<String>();
        localSpyCommandAliases = new ArrayList<String>();
        broadcastCommandAliases = new ArrayList<String>();
        chatFilters = new HashMap<String, List<ChatFilter>>();
        webhookUrls = new HashMap<String, URL>();
        serverNameReplacement = new HashMap<String, String>();
    }
}

