/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.filter.replacer.ReplacerFilter;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class PrivateMessage {
    private Player sender;
    private List<String> targetUsernames;
    private String message;
    private HuskChat implementor;

    public PrivateMessage(Player sender, List<String> targetUsernames, String message, HuskChat implementor) {
        this.sender = sender;
        this.targetUsernames = targetUsernames;
        this.message = message;
        this.implementor = implementor;
    }

    public void dispatch() {
        for (String restrictedServer : Settings.messageCommandRestrictedServers) {
            if (!restrictedServer.equalsIgnoreCase(this.sender.getServerName())) continue;
            this.implementor.getMessageManager().sendMessage(this.sender, "error_message_restricted_server");
            return;
        }
        if (this.targetUsernames.size() > 1 && !Settings.doGroupMessages) {
            this.implementor.getMessageManager().sendMessage(this.sender, "error_group_messages_disabled");
            return;
        }
        ArrayList<Player> targetPlayers = new ArrayList<Player>();
        HashSet<UUID> targetUUIDs = new HashSet<UUID>();
        for (String targetUsername : this.targetUsernames) {
            Optional<Player> targetPlayer = ConsolePlayer.isConsolePlayer(targetUsername) ? Optional.of(ConsolePlayer.adaptConsolePlayer(this.implementor)) : this.implementor.matchPlayer(targetUsername);
            if (!targetPlayer.isPresent()) continue;
            if (targetPlayer.get().getUuid().equals(this.sender.getUuid())) {
                this.implementor.getMessageManager().sendMessage(this.sender, "error_cannot_message_self");
                return;
            }
            if (targetUUIDs.contains(targetPlayer.get().getUuid())) continue;
            targetPlayers.add(targetPlayer.get());
            targetUUIDs.add(targetPlayer.get().getUuid());
        }
        if (targetPlayers.size() > Settings.maxGroupMessageSize) {
            this.implementor.getMessageManager().sendMessage(this.sender, "error_group_messages_max", Integer.toString(Settings.maxGroupMessageSize));
            return;
        }
        if (targetPlayers.isEmpty()) {
            if (this.targetUsernames.size() > 1) {
                this.implementor.getMessageManager().sendMessage(this.sender, "error_players_not_found");
            } else {
                this.implementor.getMessageManager().sendMessage(this.sender, "error_player_not_found");
            }
            return;
        }
        AtomicReference<String> finalMessage = new AtomicReference<String>(this.message);
        if (!this.sender.hasPermission("huskchat.bypass_filters")) {
            for (ChatFilter filter : Settings.chatFilters.get("private_messages")) {
                if (this.sender.hasPermission(filter.getFilterIgnorePermission())) continue;
                if (!filter.isAllowed(this.sender, finalMessage.get())) {
                    this.implementor.getMessageManager().sendMessage(this.sender, filter.getFailureErrorMessageId());
                    return;
                }
                ChatFilter chatFilter = filter;
                if (!(chatFilter instanceof ReplacerFilter)) continue;
                ReplacerFilter replacer = (ReplacerFilter)chatFilter;
                finalMessage.set(replacer.replace(finalMessage.get()));
            }
        }
        this.implementor.getEventDispatcher().dispatchPrivateMessageEvent(this.sender, targetPlayers, finalMessage.get()).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.sender = event.getSender();
            ArrayList<Player> receivers = event.getRecipients();
            finalMessage.set(event.getMessage());
            PlayerCache.setLastMessenger(this.sender.getUuid(), receivers);
            this.implementor.getMessageManager().sendFormattedOutboundPrivateMessage(this.sender, receivers, (String)finalMessage.get());
            for (Player player2 : receivers) {
                ArrayList<Player> receivedMessageFrom = new ArrayList<Player>(receivers);
                receivedMessageFrom.removeIf(player -> player.getUuid().equals(player2.getUuid()));
                receivedMessageFrom.add(0, this.sender);
                PlayerCache.setLastMessenger(player2.getUuid(), receivedMessageFrom);
            }
            this.implementor.getMessageManager().sendFormattedInboundPrivateMessage(receivers, this.sender, (String)finalMessage.get());
            if (Settings.doSocialSpyCommand && !this.sender.hasPermission("huskchat.command.socialspy.bypass") && !((Player)receivers.stream().findFirst().get()).hasPermission("huskchat.command.socialspy.bypass")) {
                HashMap<Player, PlayerCache.SpyColor> spies = PlayerCache.getSocialSpyMessageReceivers(receivers, this.implementor);
                for (Player spy : spies.keySet()) {
                    if (spy.getUuid().equals(this.sender.getUuid())) continue;
                    if (!spy.hasPermission("huskchat.command.socialspy")) {
                        try {
                            PlayerCache.removeSocialSpy(spy);
                        }
                        catch (IOException e) {
                            this.implementor.getLoggingAdapter().log(Level.SEVERE, "Failed to remove social spy after failed permission check", e);
                        }
                        continue;
                    }
                    PlayerCache.SpyColor color = spies.get(spy);
                    this.implementor.getMessageManager().sendFormattedSocialSpyMessage(spy, color, this.sender, receivers, (String)finalMessage.get());
                }
            }
            if (Settings.logPrivateMessages) {
                StringJoiner formattedPlayers = new StringJoiner(", ");
                for (Player player3 : receivers) {
                    formattedPlayers.add(player3.getName());
                }
                String string3 = Settings.messageLogFormat;
                string3 = string3.replaceAll("%sender%", this.sender.getName());
                string3 = string3.replaceAll("%receiver%", formattedPlayers.toString());
                this.implementor.getLoggingAdapter().log(Level.INFO, string3 + finalMessage);
            }
        });
    }
}

