/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity.util;

import java.util.logging.Level;
import org.slf4j.Logger;

public class VelocityLogger
implements net.william278.huskchat.util.Logger {
    private Logger parent;
    private static VelocityLogger instance;

    private VelocityLogger() {
    }

    public static VelocityLogger get(Logger parent) {
        if (instance == null) {
            instance = new VelocityLogger();
            VelocityLogger.instance.parent = parent;
        }
        return instance;
    }

    @Override
    public void log(Level level, String message, Exception e) {
        this.logMessage(level, message);
        e.printStackTrace();
    }

    @Override
    public void log(Level level, String message) {
        this.logMessage(level, message);
    }

    @Override
    public void info(String message) {
        this.logMessage(Level.INFO, message);
    }

    @Override
    public void severe(String message) {
        this.logMessage(Level.SEVERE, message);
    }

    @Override
    public void config(String message) {
        this.logMessage(Level.CONFIG, message);
    }

    private void logMessage(Level level, String message) {
        switch (level.intValue()) {
            case 1000: {
                this.parent.error(message);
                break;
            }
            case 900: {
                this.parent.warn(message);
                break;
            }
            case 70: {
                this.parent.warn("[Config] " + message);
                break;
            }
            default: {
                this.parent.info(message);
            }
        }
    }
}

