/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.adventure.identity;

import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import net.william278.huskchat.libraries.adventure.identity.IdentityImpl;
import net.william278.huskchat.libraries.adventure.identity.NilIdentity;
import net.william278.huskchat.libraries.adventure.key.Key;
import net.william278.huskchat.libraries.adventure.pointer.Pointer;
import net.william278.huskchat.libraries.adventure.text.Component;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.examination.Examinable;
import net.william278.huskchat.libraries.examination.ExaminableProperty;

public interface Identity
extends Examinable {
    public static final Pointer<String> NAME = Pointer.pointer(String.class, Key.key("adventure", "name"));
    public static final Pointer<UUID> UUID = Pointer.pointer(UUID.class, Key.key("adventure", "uuid"));
    public static final Pointer<Component> DISPLAY_NAME = Pointer.pointer(Component.class, Key.key("adventure", "display_name"));
    public static final Pointer<Locale> LOCALE = Pointer.pointer(Locale.class, Key.key("adventure", "locale"));

    @NotNull
    public static Identity nil() {
        return NilIdentity.INSTANCE;
    }

    @NotNull
    public static Identity identity(@NotNull UUID uuid) {
        if (uuid.equals(NilIdentity.NIL_UUID)) {
            return NilIdentity.INSTANCE;
        }
        return new IdentityImpl(uuid);
    }

    @NotNull
    public UUID uuid();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("uuid", this.uuid()));
    }
}

