/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.minedown.adventure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.william278.huskchat.libraries.adventure.key.Key;
import net.william278.huskchat.libraries.adventure.nbt.api.BinaryTagHolder;
import net.william278.huskchat.libraries.adventure.text.Component;
import net.william278.huskchat.libraries.adventure.text.ComponentBuilder;
import net.william278.huskchat.libraries.adventure.text.TextComponent;
import net.william278.huskchat.libraries.adventure.text.event.ClickEvent;
import net.william278.huskchat.libraries.adventure.text.event.HoverEvent;
import net.william278.huskchat.libraries.adventure.text.format.NamedTextColor;
import net.william278.huskchat.libraries.adventure.text.format.TextColor;
import net.william278.huskchat.libraries.adventure.text.format.TextDecoration;
import net.william278.huskchat.libraries.adventure.text.format.TextFormat;
import net.william278.huskchat.libraries.adventure.util.Buildable;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.libraries.minedown.adventure.Util;

public class MineDownParser {
    private static final String RAINBOW = "rainbow";
    private char colorChar = (char)38;
    private Set<Option> enabledOptions = EnumSet.of(Option.LEGACY_COLORS, Option.SIMPLE_FORMATTING, Option.ADVANCED_FORMATTING);
    private Set<Option> filteredOptions = EnumSet.noneOf(Option.class);
    private boolean lenient = false;
    private boolean urlDetection = true;
    private String urlHoverText = "Click to open url";
    private boolean autoAddUrlPrefix = true;
    private int hoverTextWidth = 60;
    public static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
    private ComponentBuilder<?, ?> builder;
    private StringBuilder value;
    private String font;
    private String insertion;
    private Integer rainbowPhase;
    private Map<TextColor, Boolean> colors;
    private Map<TextDecoration, Boolean> format;
    private boolean formattingIsLegacy = false;
    private ClickEvent clickEvent;
    private HoverEvent hoverEvent;

    public MineDownParser() {
        this.reset();
    }

    public ComponentBuilder parse(String message) throws IllegalArgumentException {
        Matcher urlMatcher = this.urlDetection() ? URL_PATTERN.matcher(message) : null;
        boolean escaped = false;
        for (int i = 0; i < message.length(); ++i) {
            boolean isFormatting;
            int definitionClose;
            char c = message.charAt(i);
            boolean isEscape = c == '\\' && i + 1 < message.length();
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < message.length() && (c == '\u00a7' || c == this.colorChar());
            int eventEndIndex = -1;
            String eventDefinition = null;
            if (!escaped && this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[' && (eventEndIndex = Util.getUnescapedEndIndex(message, '[', ']', i)) != -1 && message.length() > eventEndIndex + 1 && message.charAt(eventEndIndex + 1) == '(' && (definitionClose = Util.getUnescapedEndIndex(message, '(', ')', eventEndIndex + 1)) != -1) {
                eventDefinition = message.substring(eventEndIndex + 2, definitionClose);
            }
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(message, i) && message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2) != -1;
            if (escaped) {
                escaped = false;
            } else {
                if (isEscape) {
                    escaped = true;
                    continue;
                }
                if (isColorCode) {
                    TextFormat format;
                    char code;
                    if ((code = message.charAt(++i)) >= 'A' && code <= 'Z') {
                        code = (char)(code + 32);
                    }
                    Integer rainbowPhase = null;
                    Map<Object, Object> encoded = null;
                    Option filterOption = null;
                    StringBuilder colorString = new StringBuilder();
                    for (int j = i; j < message.length(); ++j) {
                        char c1 = message.charAt(j);
                        if (c1 == c && colorString.length() > 1) {
                            String colorStr = colorString.toString();
                            rainbowPhase = MineDownParser.parseRainbow(colorStr, "", this.lenient());
                            if (rainbowPhase == null && !colorStr.contains("=")) {
                                encoded = MineDownParser.parseFormat(colorStr, "", true);
                                if (encoded.isEmpty()) {
                                    encoded = null;
                                    break;
                                }
                                filterOption = Option.SIMPLE_FORMATTING;
                                i = j;
                                break;
                            }
                            filterOption = Option.SIMPLE_FORMATTING;
                            i = j;
                            break;
                        }
                        if (!(c1 == '_' || c1 == '#' || c1 == '-' || c1 == ',' || c1 == ':' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z' || c1 >= '0' && c1 <= '9')) break;
                        colorString.append(c1);
                    }
                    if (rainbowPhase == null && encoded == null && (format = Util.getFormatFromLegacy(code)) != null) {
                        filterOption = Option.LEGACY_COLORS;
                        encoded = new LinkedHashMap<TextFormat, Boolean>();
                        encoded.put(format, true);
                    }
                    if (rainbowPhase != null || encoded != null) {
                        if (this.isFiltered(filterOption)) continue;
                        if (encoded != null && encoded.size() == 1) {
                            Map.Entry single = encoded.entrySet().iterator().next();
                            if (single.getKey() == Util.TextControl.RESET) {
                                if (this.builder() == null && (this.format() != null && !this.format().isEmpty() || this.colors() != null && !this.colors().isEmpty())) {
                                    this.builder(Component.text());
                                }
                                this.appendValue();
                                this.colors(new LinkedHashMap<TextColor, Boolean>());
                                this.rainbowPhase(null);
                                this.format(new HashMap<TextDecoration, Boolean>());
                                continue;
                            }
                            if (single.getKey() instanceof TextColor) {
                                if (this.value().length() > 0) {
                                    if (this.builder() == null && this.format() != null && !this.format().isEmpty()) {
                                        this.builder(Component.text());
                                    }
                                    this.appendValue();
                                }
                                this.colors(new LinkedHashMap<TextColor, Boolean>());
                                this.colors().put((TextColor)single.getKey(), (Boolean)single.getValue());
                                this.rainbowPhase(null);
                                if (!this.formattingIsLegacy()) continue;
                                this.format(new HashMap<TextDecoration, Boolean>());
                                continue;
                            }
                            if (!(single.getKey() instanceof TextDecoration)) continue;
                            if (this.value.length() > 0) {
                                this.appendValue();
                            }
                            this.formattingIsLegacy(true);
                            this.format().put((TextDecoration)single.getKey(), (Boolean)single.getValue());
                            continue;
                        }
                        if (this.value().length() > 0) {
                            this.appendValue();
                        }
                        this.rainbowPhase(rainbowPhase);
                        if (encoded != null) {
                            LinkedHashMap<TextColor, Boolean> colors = new LinkedHashMap<TextColor, Boolean>();
                            for (Map.Entry e : encoded.entrySet()) {
                                if (!(e.getKey() instanceof TextColor)) continue;
                                colors.put((TextColor)e.getKey(), (Boolean)e.getValue());
                            }
                            this.colors(colors);
                        } else {
                            this.colors(null);
                        }
                        if (!this.formattingIsLegacy()) continue;
                        this.format(new HashMap<TextDecoration, Boolean>());
                        continue;
                    }
                    this.value().append(c).append(code);
                    continue;
                }
                if (eventEndIndex != -1 && eventDefinition != null) {
                    this.appendValue();
                    if (!this.isFiltered(Option.ADVANCED_FORMATTING) && !eventDefinition.isEmpty()) {
                        this.append(this.parseEvent(message.substring(i + 1, eventEndIndex), eventDefinition));
                    } else {
                        this.append(this.copy(true).parse(message.substring(i + 1, eventEndIndex)));
                    }
                    i = eventEndIndex + 2 + eventDefinition.length();
                    continue;
                }
                if (isFormatting) {
                    int endIndex = message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2);
                    HashMap<TextDecoration, Boolean> formats = new HashMap<TextDecoration, Boolean>(this.format());
                    if (!this.isFiltered(Option.SIMPLE_FORMATTING)) {
                        formats.put(MineDown.getFormatFromChar(c), true);
                    }
                    this.formattingIsLegacy(false);
                    this.appendValue();
                    this.append(this.copy(true).format(formats).parse(message.substring(i + 2, endIndex)));
                    i = endIndex + 1;
                    continue;
                }
            }
            if (this.urlDetection() && urlMatcher != null) {
                int urlEnd = message.indexOf(32, i);
                if (urlEnd == -1) {
                    urlEnd = message.length();
                }
                if (urlMatcher.region(i, urlEnd).find()) {
                    this.appendValue();
                    this.value(new StringBuilder(message.substring(i, urlEnd)));
                    this.appendValue();
                    i = urlEnd - 1;
                    continue;
                }
            }
            this.value().append(message.charAt(i));
        }
        if (escaped) {
            this.value().append('\\');
        }
        this.appendValue();
        if (this.builder() == null) {
            this.builder(Component.text());
        }
        return this.builder();
    }

    private void append(ComponentBuilder<?, ?> builder) {
        if (this.builder() == null) {
            this.builder((ComponentBuilder)Component.text().append(builder));
        } else {
            this.builder().append(builder);
        }
    }

    private void appendValue() {
        Buildable.Builder<TextComponent> builder;
        List<Object> applicableColors;
        long valueCodepointLength = this.value().length();
        if (valueCodepointLength == 0L) {
            return;
        }
        if (this.rainbowPhase() != null) {
            valueCodepointLength = this.value().codePoints().count();
            applicableColors = Util.createRainbow(valueCodepointLength, (int)this.rainbowPhase());
        } else if (this.colors() != null) {
            if (this.colors().size() > 1) {
                valueCodepointLength = this.value().codePoints().count();
                applicableColors = Util.createGradient(valueCodepointLength, this.colors.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).filter(Objects::nonNull).collect(Collectors.toList()));
            } else {
                applicableColors = new ArrayList<TextColor>(this.colors.keySet());
            }
        } else {
            applicableColors = new ArrayList();
        }
        if (applicableColors.size() > 1) {
            builder = Component.text();
        } else {
            builder = Component.text(this.value().toString()).toBuilder();
            if (applicableColors.size() == 1) {
                builder.color((TextColor)applicableColors.get(0));
            }
        }
        if (this.font() != null) {
            builder.font(Key.key(this.font()));
        }
        builder.insertion(this.insertion());
        Util.applyFormat(builder, this.format);
        if (this.urlDetection() && URL_PATTERN.matcher(this.value).matches()) {
            String v = this.value.toString();
            if (!v.startsWith("http://") && !v.startsWith("https://")) {
                v = "http://" + v;
            }
            builder.clickEvent(ClickEvent.clickEvent(ClickEvent.Action.OPEN_URL, v));
            if (this.urlHoverText() != null && !this.urlHoverText().isEmpty()) {
                builder.hoverEvent(HoverEvent.hoverEvent(HoverEvent.Action.SHOW_TEXT, new MineDown(this.urlHoverText()).replace("url", this.value.toString()).toComponent()));
            }
        }
        if (this.clickEvent() != null) {
            builder.clickEvent(this.clickEvent());
        }
        if (this.hoverEvent() != null) {
            builder.hoverEvent(this.hoverEvent());
        }
        if (applicableColors.size() > 1) {
            int stepLength = (int)Math.round((double)valueCodepointLength / (double)applicableColors.size());
            Buildable.Builder component = Component.empty().toBuilder();
            StringBuilder sb = new StringBuilder();
            int colorIndex = 0;
            int steps = 0;
            PrimitiveIterator.OfInt it = this.value().codePoints().iterator();
            while (it.hasNext()) {
                sb.appendCodePoint(it.next());
                if (++steps != stepLength) continue;
                steps = 0;
                component.append(Component.text(sb.toString()).color((TextColor)applicableColors.get(colorIndex++)));
                sb = new StringBuilder();
            }
            builder.append((ComponentBuilder<?, ?>)component);
        }
        if (this.builder() == null) {
            this.builder((ComponentBuilder)builder);
        } else {
            this.builder().append((ComponentBuilder<?, ?>)builder);
        }
        this.value(new StringBuilder());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ComponentBuilder parseEvent(String text, String definitions) {
        defParts = new ArrayList<String>();
        if (definitions.startsWith(" ")) {
            defParts.add("");
        }
        Collections.addAll(defParts, definitions.split(" "));
        if (definitions.endsWith(" ")) {
            defParts.add("");
        }
        rainbowPhase = null;
        colors = null;
        font = null;
        insertion = null;
        formats = new HashMap<TextDecoration, Boolean>();
        clickEvent = null;
        hoverEvent = null;
        formatEnd = -1;
        i = new AtomicInteger();
        while (i.get() < defParts.size()) {
            block54: {
                definition = (String)defParts.get(i.get());
                parsedRainbowPhase = MineDownParser.parseRainbow(definition, "", this.lenient());
                if (parsedRainbowPhase != null) {
                    this.rainbowPhase(parsedRainbowPhase);
                } else if (!definition.contains("=") && (parsed = MineDownParser.parseFormat(definition, "", true)) != null && !parsed.isEmpty()) {
                    for (Map.Entry<TextFormat, Boolean> e : parsed.entrySet()) {
                        if (e.getKey() instanceof TextColor) {
                            if (colors == null) {
                                colors = new LinkedHashMap<TextColor, Boolean>();
                            }
                            colors.put((TextColor)e.getKey(), e.getValue());
                            continue;
                        }
                        if (!(e.getKey() instanceof TextDecoration)) continue;
                        formats.put((TextDecoration)e.getKey(), e.getValue());
                    }
                    formatEnd = i.get();
                } else if (definition.toLowerCase(Locale.ROOT).startsWith("font=")) {
                    font = definition.substring("font=".length());
                } else if (definition.toLowerCase(Locale.ROOT).startsWith("insert=")) {
                    insertion = this.getValue(i, definition.substring("insert=".length()), defParts, true);
                } else if (definition.toLowerCase(Locale.ROOT).startsWith("color=")) {
                    rainbowPhase = MineDownParser.parseRainbow(definition, "color=", this.lenient());
                    if (rainbowPhase == null) {
                        parsed = MineDownParser.parseFormat(definition, "color=", this.lenient());
                        colors = new LinkedHashMap<K, V>();
                        for (Map.Entry<TextFormat, Boolean> e : parsed.entrySet()) {
                            if (e.getKey() instanceof TextColor) {
                                colors.put((TextColor)e.getKey(), e.getValue());
                                continue;
                            }
                            if (this.lenient()) continue;
                            throw new IllegalArgumentException(e + "  is a format and not a color!");
                        }
                    }
                    formatEnd = i.get();
                } else if (definition.toLowerCase(Locale.ROOT).startsWith("format=")) {
                    parsed = MineDownParser.parseFormat(definition, "format=", this.lenient());
                    for (Map.Entry<TextFormat, Boolean> e : parsed.entrySet()) {
                        if (e.getKey() instanceof TextDecoration) {
                            formats.put((TextDecoration)e.getKey(), e.getValue());
                            continue;
                        }
                        if (this.lenient()) continue;
                        throw new IllegalArgumentException(e + " is a color and not a format!");
                    }
                    formatEnd = i.get();
                } else if (i.get() == formatEnd + 1 && MineDownParser.URL_PATTERN.matcher(definition).matches()) {
                    if (!definition.startsWith("http://") && !definition.startsWith("https://")) {
                        definition = "http://" + definition;
                    }
                    clickEvent = ClickEvent.clickEvent(ClickEvent.Action.OPEN_URL, definition);
                } else {
                    clickAction = definition.startsWith("/") != false ? ClickEvent.Action.RUN_COMMAND : null;
                    hoverAction /* !! */  = null;
                    if (definition.toLowerCase(Locale.ROOT).startsWith("hover=")) {
                        hoverAction /* !! */  = HoverEvent.Action.SHOW_TEXT;
                    }
                    parts = definition.split("=", 2);
                    try {
                        hoverAction /* !! */  = HoverEvent.Action.NAMES.value(parts[0].toLowerCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException var18_19) {
                        // empty catch block
                    }
                    try {
                        clickAction = ClickEvent.Action.valueOf(parts[0].toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException var18_20) {
                        // empty catch block
                    }
                    valueStr = this.getValue(i, parts.length > 1 ? parts[1] : "", defParts, clickAction != null || hoverAction /* !! */  != null);
                    if (clickAction != null) {
                        if (this.autoAddUrlPrefix() && clickAction == ClickEvent.Action.OPEN_URL && !valueStr.startsWith("http://") && !valueStr.startsWith("https://")) {
                            valueStr = "http://" + valueStr;
                        }
                        clickEvent = ClickEvent.clickEvent(clickAction, valueStr);
                    } else if (hoverAction /* !! */  == null) {
                        hoverAction /* !! */  = HoverEvent.Action.SHOW_TEXT;
                    }
                    if (hoverAction /* !! */  != null) {
                        if (hoverAction /* !! */  == HoverEvent.Action.SHOW_TEXT) {
                            hoverEvent = HoverEvent.hoverEvent(hoverAction /* !! */ , this.copy(false).urlDetection(false).parse(Util.wrap(valueStr, this.hoverTextWidth())).build());
                        } else if (hoverAction /* !! */  == HoverEvent.Action.SHOW_ENTITY) {
                            valueParts = valueStr.split(":", 2);
                            try {
                                additionalParts = valueParts[1].split(" ", 2);
                                if (!additionalParts[0].contains(":")) {
                                    additionalParts[0] = "minecraft:" + additionalParts[0];
                                }
                                hoverEvent = HoverEvent.showEntity(HoverEvent.ShowEntity.of(Key.key(additionalParts[0]), UUID.fromString(valueParts[0]), additionalParts.length > 1 && additionalParts[1] != null ? this.copy(false).urlDetection(false).parse(additionalParts[1]).build() : null));
                            }
                            catch (Exception e) {
                                if (this.lenient()) ** GOTO lbl141
                                if (valueParts.length < 2) {
                                    throw new IllegalArgumentException("Invalid entity definition. Needs to be of format uuid:id or uuid:namespace:id!");
                                }
                                throw new IllegalArgumentException(e.getMessage());
                            }
                        } else if (hoverAction /* !! */  == HoverEvent.Action.SHOW_ITEM) {
                            block53: {
                                valueParts = valueStr.split(" ", 2);
                                id = valueParts[0];
                                if (!id.contains(":")) {
                                    id = "minecraft:" + id;
                                }
                                count = 1;
                                countIndex = valueParts[0].indexOf(42);
                                if (countIndex > 0 && countIndex + 1 < valueParts[0].length()) {
                                    try {
                                        count = Integer.parseInt(valueParts[0].substring(countIndex + 1));
                                        id = valueParts[0].substring(0, countIndex);
                                    }
                                    catch (NumberFormatException e) {
                                        if (this.lenient()) break block53;
                                        throw new IllegalArgumentException(e.getMessage());
                                    }
                                }
                            }
                            tag = null;
                            if (valueParts.length > 1 && valueParts[1] != null) {
                                tag = BinaryTagHolder.of(valueParts[1]);
                            }
                            try {
                                hoverEvent = HoverEvent.showItem(HoverEvent.ShowItem.of(Key.key(id), count, tag));
                            }
                            catch (Exception e) {
                                if (this.lenient()) break block54;
                                throw new IllegalArgumentException(e.getMessage());
                            }
                        }
                    }
                }
            }
            i.incrementAndGet();
        }
        if (clickEvent != null && hoverEvent == null) {
            hoverEvent = HoverEvent.hoverEvent(HoverEvent.Action.SHOW_TEXT, ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(clickEvent.action().toString().toLowerCase(Locale.ROOT).replace('_', ' ')))).color(NamedTextColor.BLUE)).append((Component)Component.text(" " + clickEvent.value()))).color(NamedTextColor.WHITE)).build());
        }
        return this.copy().urlDetection(false).rainbowPhase(rainbowPhase).colors(colors).font(font).insertion(insertion).format(formats).clickEvent(clickEvent).hoverEvent(hoverEvent).parse(text);
    }

    private String getValue(AtomicInteger i, String firstPart, List<String> defParts, boolean hasAction) {
        int bracketDepth = !firstPart.isEmpty() && firstPart.startsWith("{") && hasAction ? 1 : 0;
        StringBuilder value = new StringBuilder();
        if (!firstPart.isEmpty() && hasAction) {
            if (bracketDepth > 0) {
                value.append(firstPart.substring(1));
            } else {
                value.append(firstPart);
            }
        } else {
            value.append(defParts.get(i.get()));
        }
        i.incrementAndGet();
        while (i.get() < defParts.size()) {
            int equalsIndex;
            String part = defParts.get(i.get());
            if (bracketDepth == 0 && (equalsIndex = part.indexOf(61)) > 0 && !Util.isEscaped(part, equalsIndex)) {
                i.decrementAndGet();
                break;
            }
            value.append(" ");
            if (bracketDepth > 0) {
                int startBracketIndex = part.indexOf("={");
                if (startBracketIndex > 0 && !Util.isEscaped(part, startBracketIndex) && !Util.isEscaped(part, startBracketIndex + 1)) {
                    ++bracketDepth;
                }
                if (part.endsWith("}") && !Util.isEscaped(part, part.length() - 1) && --bracketDepth == 0) {
                    value.append(part, 0, part.length() - 1);
                    break;
                }
            }
            value.append(part);
            i.incrementAndGet();
        }
        return value.toString();
    }

    protected ComponentBuilder<?, ?> builder() {
        return this.builder;
    }

    protected MineDownParser builder(ComponentBuilder builder) {
        this.builder = builder;
        return this;
    }

    protected MineDownParser value(StringBuilder value) {
        this.value = value;
        return this;
    }

    protected StringBuilder value() {
        return this.value;
    }

    private MineDownParser font(String font) {
        this.font = font;
        return this;
    }

    protected String font() {
        return this.font;
    }

    private MineDownParser insertion(String insertion) {
        this.insertion = insertion;
        return this;
    }

    protected String insertion() {
        return this.insertion;
    }

    protected MineDownParser colors(Map<TextColor, Boolean> colors) {
        this.colors = colors;
        return this;
    }

    protected MineDownParser rainbowPhase(Integer rainbowPhase) {
        this.rainbowPhase = rainbowPhase;
        return this;
    }

    protected Integer rainbowPhase() {
        return this.rainbowPhase;
    }

    protected Map<TextColor, Boolean> colors() {
        return this.colors;
    }

    protected MineDownParser format(Map<TextDecoration, Boolean> format) {
        this.format = format;
        return this;
    }

    protected Map<TextDecoration, Boolean> format() {
        return this.format;
    }

    protected MineDownParser formattingIsLegacy(boolean formattingIsLegacy) {
        this.formattingIsLegacy = formattingIsLegacy;
        return this;
    }

    protected boolean formattingIsLegacy() {
        return this.formattingIsLegacy;
    }

    protected MineDownParser clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    protected ClickEvent clickEvent() {
        return this.clickEvent;
    }

    protected MineDownParser hoverEvent(HoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }

    protected HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    private static Integer parseRainbow(String colorString, String prefix, boolean lenient) {
        if (colorString.substring(prefix.length()).toLowerCase(Locale.ROOT).startsWith(RAINBOW)) {
            if (colorString.length() > prefix.length() + RAINBOW.length() + 1) {
                try {
                    return Integer.parseInt(colorString.substring(prefix.length() + RAINBOW.length() + 1));
                }
                catch (NumberFormatException e) {
                    if (!lenient) {
                        throw e;
                    }
                }
            } else {
                return 0;
            }
        }
        return null;
    }

    public static Map<TextFormat, Boolean> parseFormat(String colorString, String prefix, boolean lenient) {
        LinkedHashMap<TextFormat, Boolean> formats = new LinkedHashMap<TextFormat, Boolean>();
        if (prefix.length() + 1 == colorString.length()) {
            TextFormat format = Util.getFormatFromLegacy(colorString.charAt(prefix.length()));
            if (format == null && !lenient) {
                throw new IllegalArgumentException(colorString.charAt(prefix.length()) + " is not a valid " + prefix + " char!");
            }
            formats.put(format, true);
        } else {
            for (String part : colorString.substring(prefix.length()).split("[\\-,]")) {
                TextFormat format;
                boolean negated;
                block10: {
                    if (part.isEmpty()) continue;
                    boolean bl = negated = part.charAt(0) == '!';
                    if (negated) {
                        part = part.substring(1);
                    }
                    if (part.charAt(0) == '#') {
                        format = TextColor.fromCSSHexString(part);
                    } else {
                        format = NamedTextColor.NAMES.value(part.toLowerCase(Locale.ROOT));
                        if (format == null) {
                            try {
                                format = TextDecoration.valueOf(part.toUpperCase(Locale.ROOT));
                            }
                            catch (IllegalArgumentException e2) {
                                if (lenient) break block10;
                                throw e2;
                            }
                        }
                    }
                }
                if (format == null) continue;
                formats.put(format, !negated);
            }
        }
        return formats;
    }

    public MineDownParser copy() {
        return this.copy(false);
    }

    public MineDownParser copy(boolean formatting) {
        return new MineDownParser().copy(this, formatting);
    }

    public MineDownParser copy(MineDownParser from) {
        return this.copy(from, false);
    }

    public MineDownParser copy(MineDownParser from, boolean formatting) {
        this.lenient(from.lenient());
        this.urlDetection(from.urlDetection());
        this.urlHoverText(from.urlHoverText());
        this.autoAddUrlPrefix(from.autoAddUrlPrefix());
        this.hoverTextWidth(from.hoverTextWidth());
        this.enabledOptions(from.enabledOptions());
        this.filteredOptions(from.filteredOptions());
        this.colorChar(from.colorChar());
        if (formatting) {
            this.format(from.format());
            this.formattingIsLegacy(from.formattingIsLegacy());
            this.rainbowPhase(from.rainbowPhase());
            this.colors(from.colors());
            this.clickEvent(from.clickEvent());
            this.hoverEvent(from.hoverEvent());
        }
        return this;
    }

    public MineDownParser reset() {
        this.builder = null;
        this.value = new StringBuilder();
        this.font = null;
        this.insertion = null;
        this.rainbowPhase = null;
        this.colors = null;
        this.format = new HashMap<TextDecoration, Boolean>();
        this.clickEvent = null;
        this.hoverEvent = null;
        return this;
    }

    @Deprecated
    public boolean translateLegacyColors() {
        return this.isEnabled(Option.LEGACY_COLORS);
    }

    @Deprecated
    public MineDownParser translateLegacyColors(boolean enabled) {
        return enabled ? this.enable(Option.LEGACY_COLORS) : this.disable(Option.LEGACY_COLORS);
    }

    public boolean isEnabled(Option option) {
        return this.enabledOptions().contains((Object)option);
    }

    public MineDownParser enable(Option option) {
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser disable(Option option) {
        this.enabledOptions().remove((Object)option);
        return this;
    }

    public boolean isFiltered(Option option) {
        return this.filteredOptions().contains((Object)option);
    }

    public MineDownParser filter(Option option) {
        this.filteredOptions().add(option);
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser unfilter(Option option) {
        this.filteredOptions().remove((Object)option);
        return this;
    }

    public String escape(String string) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean isFormatting;
            char c = string.charAt(i);
            boolean isEscape = c == '\\';
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < string.length() && (c == '\u00a7' || c == this.colorChar());
            boolean isEvent = this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[';
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(string, i);
            if (isEscape || isColorCode || isEvent || isFormatting) {
                value.append('\\');
            }
            value.append(c);
        }
        return value.toString();
    }

    public char colorChar() {
        return this.colorChar;
    }

    public MineDownParser colorChar(char colorChar) {
        this.colorChar = colorChar;
        return this;
    }

    public Set<Option> enabledOptions() {
        return this.enabledOptions;
    }

    public MineDownParser enabledOptions(Set<Option> enabledOptions) {
        this.enabledOptions = enabledOptions;
        return this;
    }

    public Set<Option> filteredOptions() {
        return this.filteredOptions;
    }

    public MineDownParser filteredOptions(Set<Option> filteredOptions) {
        this.filteredOptions = filteredOptions;
        return this;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public MineDownParser lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean urlDetection() {
        return this.urlDetection;
    }

    public MineDownParser urlDetection(boolean urlDetection) {
        this.urlDetection = urlDetection;
        return this;
    }

    public String urlHoverText() {
        return this.urlHoverText;
    }

    public MineDownParser urlHoverText(String urlHoverText) {
        this.urlHoverText = urlHoverText;
        return this;
    }

    public boolean autoAddUrlPrefix() {
        return this.autoAddUrlPrefix;
    }

    public MineDownParser autoAddUrlPrefix(boolean autoAddUrlPrefix) {
        this.autoAddUrlPrefix = autoAddUrlPrefix;
        return this;
    }

    public int hoverTextWidth() {
        return this.hoverTextWidth;
    }

    public MineDownParser hoverTextWidth(int hoverTextWidth) {
        this.hoverTextWidth = hoverTextWidth;
        return this;
    }

    public static enum Option {
        SIMPLE_FORMATTING,
        ADVANCED_FORMATTING,
        LEGACY_COLORS;

    }
}

