/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.libraries.boostedyaml.YamlDocument;
import net.william278.huskchat.libraries.boostedyaml.block.implementation.Section;
import net.william278.huskchat.message.MessageManager;
import net.william278.huskchat.player.Player;

public class PlayerCache {
    private static File dataFolder;
    private static final HashMap<UUID, String> playerChannels;
    private static final HashMap<UUID, HashSet<UUID>> lastMessagePlayers;
    private static final HashMap<UUID, SpyColor> socialSpies;
    private static final HashMap<UUID, SpyColor> localSpies;

    public static String getPlayerChannel(UUID uuid) {
        if (!playerChannels.containsKey(uuid)) {
            return Settings.defaultChannel;
        }
        return playerChannels.get(uuid);
    }

    public static void setPlayerChannel(UUID uuid, String playerChannel) {
        playerChannels.put(uuid, playerChannel);
    }

    public static void switchPlayerChannel(Player player, String channelID, MessageManager messageManager) {
        Channel channel = Settings.channels.get(channelID);
        if (channel == null) {
            messageManager.sendMessage(player, "error_invalid_channel");
            return;
        }
        if (channel.sendPermission != null && !player.hasPermission(channel.sendPermission)) {
            messageManager.sendMessage(player, "error_no_permission_send", channel.id);
            return;
        }
        PlayerCache.setPlayerChannel(player.getUuid(), channel.id);
        messageManager.sendMessage(player, "channel_switched", channel.id);
    }

    public static Optional<HashSet<UUID>> getLastMessengers(UUID uuid) {
        if (lastMessagePlayers.containsKey(uuid)) {
            return Optional.of(lastMessagePlayers.get(uuid));
        }
        return Optional.empty();
    }

    public static void setLastMessenger(UUID playerToSet, ArrayList<Player> lastMessengers) {
        HashSet<UUID> uuidPlayers = new HashSet<UUID>();
        for (Player player : lastMessengers) {
            uuidPlayers.add(player.getUuid());
        }
        lastMessagePlayers.put(playerToSet, uuidPlayers);
    }

    public static boolean isSocialSpying(Player player) {
        return socialSpies.containsKey(player.getUuid());
    }

    public static void setSocialSpy(Player player) throws IOException {
        socialSpies.put(player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
        PlayerCache.addSpy("social", player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
    }

    public static void setSocialSpy(Player player, SpyColor spyColor) throws IOException {
        socialSpies.put(player.getUuid(), spyColor);
        PlayerCache.addSpy("social", player.getUuid(), spyColor);
    }

    public static void removeSocialSpy(Player player) throws IOException {
        socialSpies.remove(player.getUuid());
        PlayerCache.removeSpy("social", player.getUuid());
    }

    public static HashMap<Player, SpyColor> getSocialSpyMessageReceivers(ArrayList<Player> messageRecipients, HuskChat implementor) {
        HashMap<Player, SpyColor> receivers = new HashMap<Player, SpyColor>();
        block0: for (UUID player : socialSpies.keySet()) {
            SpyColor color = socialSpies.get(player);
            Optional<Player> spy = implementor.getPlayer(player);
            if (spy.isEmpty()) continue;
            for (Player messageRecipient : messageRecipients) {
                if (!player.equals(messageRecipient.getUuid())) continue;
                continue block0;
            }
            receivers.put(spy.get(), color);
        }
        return receivers;
    }

    public static boolean isLocalSpying(Player player) {
        return localSpies.containsKey(player.getUuid());
    }

    public static void setLocalSpy(Player player) throws IOException {
        localSpies.put(player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
        PlayerCache.addSpy("local", player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
    }

    public static void setLocalSpy(Player player, SpyColor spyColor) throws IOException {
        localSpies.put(player.getUuid(), spyColor);
        PlayerCache.addSpy("local", player.getUuid(), spyColor);
    }

    public static void removeLocalSpy(Player player) throws IOException {
        localSpies.remove(player.getUuid());
        PlayerCache.removeSpy("local", player.getUuid());
    }

    public static HashMap<Player, SpyColor> getLocalSpyMessageReceivers(String localMessageServer, HuskChat implementor) {
        HashMap<Player, SpyColor> receivers = new HashMap<Player, SpyColor>();
        for (UUID player : localSpies.keySet()) {
            SpyColor color = localSpies.get(player);
            Optional<Player> spy = implementor.getPlayer(player);
            if (spy.isEmpty() || spy.get().getServerName().equals(localMessageServer)) continue;
            receivers.put(spy.get(), color);
        }
        return receivers;
    }

    public static void loadSpy() throws IOException {
        YamlDocument spies = YamlDocument.create(new File(dataFolder, "spies.yml"));
        if (spies.contains("local")) {
            Section local = spies.getSection("local");
            for (Object name : local.getKeys()) {
                localSpies.put(UUID.fromString(name.toString()), SpyColor.valueOf(local.getSection(name.toString()).getString("color")));
            }
        }
        if (spies.contains("social")) {
            Section social = spies.getSection("social");
            for (Object name : social.getKeys()) {
                socialSpies.put(UUID.fromString(name.toString()), SpyColor.valueOf(social.getSection(name.toString()).getString("color")));
            }
        }
    }

    public static void addSpy(String type, UUID uuid, SpyColor spyColor) throws IOException {
        if (!type.equals("local") && !type.equals("social")) {
            return;
        }
        YamlDocument spies = YamlDocument.create(new File(dataFolder, "spies.yml"));
        if (!spies.contains(type)) {
            spies.createSection(type);
        }
        if (!spies.getSection(type).contains(uuid.toString())) {
            spies.getSection(type).createSection(uuid.toString());
        }
        spies.getSection(type).getSection(uuid.toString()).set("color", (Object)spyColor.toString());
        spies.save();
    }

    public static void removeSpy(String type, UUID uuid) throws IOException {
        if (!type.equals("local") && !type.equals("social")) {
            return;
        }
        YamlDocument spies = YamlDocument.create(new File(dataFolder, "spies.yml"));
        if (!spies.contains(type)) {
            return;
        }
        if (!spies.getSection(type).contains(uuid.toString())) {
            return;
        }
        spies.getSection(type).remove(uuid.toString());
        if (spies.getSection(type).getKeys().size() == 0) {
            spies.remove(type);
        }
        spies.save();
    }

    public static void setDataFolder(File folder) {
        dataFolder = folder;
    }

    static {
        playerChannels = new HashMap();
        lastMessagePlayers = new HashMap();
        socialSpies = new HashMap();
        localSpies = new HashMap();
    }

    public static enum SpyColor {
        DARK_RED("&4"),
        RED("&c"),
        GOLD("&6"),
        YELLOW("&e"),
        DARK_GREEN("&2"),
        GREEN("&a"),
        AQUA("&b"),
        DARK_AQUA("&3"),
        DARK_BLUE("&1"),
        BLUE("&9"),
        LIGHT_PURPLE("&d"),
        DARK_PURPLE("&5"),
        WHITE("&f"),
        GRAY("&7"),
        DARK_GRAY("&8"),
        BLACK("&9");

        public static final SpyColor DEFAULT_SPY_COLOR;
        public final String colorCode;

        private SpyColor(String colorCode) {
            this.colorCode = colorCode;
        }

        public static List<String> getColorStrings() {
            ArrayList<String> colors = new ArrayList<String>();
            for (SpyColor color : SpyColor.values()) {
                colors.add(color.name().toLowerCase());
            }
            return colors;
        }

        public static Optional<SpyColor> getColor(String colorInput) {
            for (SpyColor color : SpyColor.values()) {
                if (!color.colorCode.replace("&", "").equals(colorInput.replace("&", "")) && !color.name().equalsIgnoreCase(colorInput.toUpperCase())) continue;
                return Optional.of(color);
            }
            return Optional.empty();
        }

        static {
            DEFAULT_SPY_COLOR = DARK_GRAY;
        }
    }
}

