/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.message.BroadcastMessage;
import net.william278.huskchat.player.Player;

public class BroadcastCommand
extends CommandBase {
    private static final String PERMISSION = "huskchat.command.broadcast";

    public BroadcastCommand(HuskChat implementor) {
        super(Settings.broadcastCommandAliases.get(0), PERMISSION, implementor, Settings.getAliases(Settings.broadcastCommandAliases));
    }

    @Override
    public void onExecute(Player player, String[] args) {
        if (player.hasPermission(this.permission)) {
            if (args.length >= 1) {
                StringJoiner message = new StringJoiner(" ");
                for (String argument : args) {
                    message.add(argument);
                }
                new BroadcastMessage(player, message.toString(), this.implementor).dispatch();
            } else {
                this.implementor.getMessageManager().sendMessage(player, "error_invalid_syntax", "/broadcast <message>");
            }
        } else {
            this.implementor.getMessageManager().sendMessage(player, "error_no_permission");
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] args) {
        return Collections.emptyList();
    }
}

