/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class ShortcutCommand
extends CommandBase {
    private static final String PERMISSION = "huskchat.command.channel";
    private final String channelId;

    public ShortcutCommand(String command, String channelId, HuskChat implementor) {
        super(command, PERMISSION, implementor, new String[0]);
        this.channelId = channelId;
    }

    @Override
    public void onExecute(Player player, String[] args) {
        if (player.hasPermission(this.permission)) {
            if (args.length == 0) {
                if (player instanceof ConsolePlayer) {
                    this.implementor.getLoggingAdapter().log(Level.INFO, this.implementor.getMessageManager().getRawMessage("error_console_switch_channels"));
                    return;
                }
                PlayerCache.switchPlayerChannel(player, this.channelId, this.implementor.getMessageManager());
            } else {
                StringJoiner message = new StringJoiner(" ");
                for (String arg : args) {
                    message.add(arg);
                }
                Channel channel = Settings.channels.get(this.channelId);
                if (channel.broadcastScope.isPassThrough) {
                    this.implementor.getMessageManager().sendMessage(player, "passthrough_shortcut_command_error");
                    return;
                }
                new ChatMessage(this.channelId, player, message.toString(), this.implementor).dispatch();
            }
        } else {
            this.implementor.getMessageManager().sendMessage(player, "error_no_permission");
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] args) {
        return Collections.emptyList();
    }
}

