/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity.player;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.velocity.HuskChatVelocity;

public class VelocityPlayer
implements net.william278.huskchat.player.Player {
    private static final HuskChatVelocity plugin = HuskChatVelocity.getInstance();
    private Player player;

    private VelocityPlayer() {
    }

    @Override
    public String getName() {
        return this.player.getUsername();
    }

    @Override
    public UUID getUuid() {
        return this.player.getUniqueId();
    }

    @Override
    public int getPing() {
        return (int)this.player.getPing();
    }

    @Override
    public String getServerName() {
        AtomicReference connection = new AtomicReference();
        this.player.getCurrentServer().ifPresent(connection::set);
        if (connection.get() != null) {
            return ((ServerConnection)connection.get()).getServerInfo().getName();
        }
        return null;
    }

    @Override
    public int getPlayersOnServer() {
        AtomicReference connection = new AtomicReference();
        this.player.getCurrentServer().ifPresent(connection::set);
        if (connection.get() != null) {
            return ((ServerConnection)connection.get()).getServer().getPlayersConnected().size();
        }
        return 0;
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @NotNull
    public Audience getAudience() {
        return this.player;
    }

    public static Optional<Player> adaptVelocity(net.william278.huskchat.player.Player player) {
        return plugin.getProxyServer().getPlayer(player.getUuid());
    }

    @NotNull
    public static VelocityPlayer adaptCrossPlatform(Player player) {
        VelocityPlayer velocityPlayer = new VelocityPlayer();
        velocityPlayer.player = player;
        return velocityPlayer;
    }
}

